// src/main/javascript/mock/mockajax.js
import { AjaxMessage } from "/js/root.package.js";
import { FLURI, FLError, Send } from "/js/flasjs.js";
var MockAjax = function(_cxt, baseUri) {
  this.baseUri = baseUri;
  this.expect = { subscribe: [] };
};
MockAjax.prototype.expectSubscribe = function(_cxt, path) {
  var mas = new MockAjaxSubscriber(_cxt, path);
  this.expect.subscribe.push(mas);
  return mas;
};
MockAjax.prototype.pump = function(_cxt) {
  for (var i = 0; i < this.expect.subscribe.length; i++) {
    this.expect.subscribe[i].dispatch(_cxt, this.baseUri, _cxt.env.activeSubscribers);
  }
};
var MockAjaxSubscriber = function(_cxt, path) {
  this.path = path;
  this.responses = [];
  this.nextResponse = 0;
};
MockAjaxSubscriber.prototype.response = function(_cxt, val) {
  this.responses.push(val);
};
MockAjaxSubscriber.prototype.dispatch = function(_cxt, baseUri, subscribers) {
  if (this.nextResponse >= this.responses.length)
    return;
  for (var i = 0; i < subscribers.length; i++) {
    if (this.matchAndSend(_cxt, baseUri, subscribers[i]))
      return;
  }
};
MockAjaxSubscriber.prototype.matchAndSend = function(_cxt, baseUri, sub) {
  if (sub.uri.toString() == new URL(this.path, baseUri).toString()) {
    var resp = this.responses[this.nextResponse++];
    resp = _cxt.full(resp);
    if (resp instanceof FLError) {
      _cxt.log(resp);
      return true;
    }
    var msg;
    if (resp instanceof AjaxMessage) {
      msg = resp;
    } else {
      msg = new AjaxMessage(_cxt);
      msg.state.set("headers", []);
      if (typeof resp === "string")
        msg.state.set("body", resp);
      else
        msg.state.set("body", JSON.stringify(resp));
    }
    _cxt.env.queueMessages(_cxt, Send.eval(_cxt, sub.handler, "message", [msg], null));
    _cxt.env.dispatchMessages(_cxt);
    return true;
  } else
    return false;
};
var MockAjaxService = function() {
};
MockAjaxService.prototype.subscribe = function(_cxt, uri, options, handler) {
  if (uri instanceof FLURI)
    uri = uri.uri;
  _cxt.env.activeSubscribers.push({ uri, options, handler });
};

// src/main/javascript/mock/mockappl.js
import { STSecurityModule } from "/js/flastest.js";
var MockAppl = function(_cxt, clz) {
  const newdiv = document.createElement("div");
  newdiv.setAttribute("id", _cxt.nextDocumentId());
  document.body.appendChild(newdiv);
  this.appl = new clz._Application(_cxt, newdiv);
  this.appl.securityModule = new STSecurityModule();
  this.appl._updateDisplay(_cxt, this.appl._currentRenderTree());
};
MockAppl.prototype._isMock = function() {
  return true;
};
MockAppl.prototype.route = function(_cxt, r, andThen) {
  this.appl.gotoRoute(_cxt, r, () => {
    this.appl._updateDisplay(_cxt, this.appl._currentRenderTree());
    andThen();
  });
};
MockAppl.prototype.userLoggedIn = function(_cxt, u) {
  this.appl.securityModule.userLoggedIn(_cxt, this.appl, u);
};
MockAppl.prototype.bindCards = function(_cxt, iv) {
  if (!iv)
    return;
  var binding = {};
  binding["main"] = this.appl.cards["main"];
  iv.bindActual({ routes: binding });
};
MockAppl.prototype._currentRenderTree = function() {
  return this.appl._currentRenderTree();
};

// src/main/javascript/mock/mockservices.js
var MockStdlibModule = function(runner) {
  this.runner = runner;
  this.ajaxen = [];
  this.appls = [];
  runner.broker.register("Ajax", new MockAjaxService());
};
MockStdlibModule.prototype.newAjax = function(cxt, baseUri) {
  var ma = new MockAjax(cxt, baseUri);
  this.ajaxen.push(ma);
  return ma;
};
MockStdlibModule.prototype.newMockAppl = function(cxt, clz) {
  var ma = new MockAppl(cxt, clz);
  this.appls.push(ma);
  return ma;
};
MockStdlibModule.prototype.route = function(_cxt, app, route, storeCards) {
  app.route(_cxt, route, () => {
    app.bindCards(_cxt, storeCards);
  });
};
MockStdlibModule.prototype.userlogin = function(_cxt, app, user) {
  app.userLoggedIn(_cxt, user);
};
MockStdlibModule.prototype.matchTitle = function(_cxt, target, zone, contains, expected) {
  var matchOn = this.runner.findMockFor(target);
  if (!matchOn)
    throw Error("there is no mock " + target);
  if (!(matchOn instanceof MockAppl))
    throw Error("can only test title on Appl");
  var titles = document.head.getElementsByTagName("title");
  var actual = "";
  for (var i = 0; i < titles.length; i++) {
    actual += titles[i].innerText.trim() + " ";
  }
  actual = actual.trim();
  actual = actual.replace(/\n/g, " ");
  actual = actual.replace(/ +/, " ");
  if (contains) {
    if (!actual.includes(expected))
      throw new Error("MATCH\n  expected to contain: " + expected + "\n  actual:   " + actual);
  } else {
    if (actual != expected)
      throw new Error("MATCH\n  expected: " + expected + "\n  actual:   " + actual);
  }
};
var installer = function(bridge) {
  bridge.runner.bindModule("stdlib", new MockStdlibModule(bridge.runner));
};
export {
  installer
};
