// src/main/javascript/live/grounduri.js
import { FLURI } from "/js/flasjs.js";
var groundUri = function(_cxt, uri) {
  try {
    if (uri instanceof FLURI) {
      uri = uri.resolve(window.location);
    } else if (typeof uri === "string") {
      uri = new URL(uri, window.location);
    } else if (!(uri instanceof URL)) {
      _cxt.log("not a valid uri", uri);
      return;
    }
  } catch (e) {
    _cxt.log("error in resolving uri from", uri, "inside", window.location);
    return;
  }
  return uri;
};

// src/main/javascript/live/ajax.js
import { AjaxMessage } from "/js/root.package.js";
var LiveAjaxService = function() {
};
LiveAjaxService.prototype.subscribe = function(_cxt, uri, options, handler) {
  uri = groundUri(_cxt, uri);
  if (uri) {
    console.log("want to subscribe to", uri);
    this.ajax(_cxt, uri, this.feedback(_cxt.env, uri, options, handler));
  }
};
LiveAjaxService.prototype.ajax = function(_cxt, uri, handler) {
  var verb = "GET";
  var xhr = new XMLHttpRequest();
  xhr.onreadystatechange = handler;
  xhr.open(verb, uri, true);
  xhr.send();
};
LiveAjaxService.prototype.feedback = function(env, uri, options, handler) {
  var self = this;
  var fb = function() {
    if (this.readyState == 4) {
      var _cxt = env.newContext();
      if (Math.floor(this.status / 100) != 2) {
        console.log("error from ajax:", this.status);
      } else {
        var msg = new AjaxMessage(_cxt);
        msg.state.set("headers", []);
        msg.state.set("body", this.responseText);
        env.queueMessages(_cxt, Send.eval(_cxt, handler, "message", [msg], null));
        env.dispatchMessages(_cxt);
      }
      var ms = options.state.get("subscribeRepeat").asJs();
      setTimeout(() => {
        self.ajax(_cxt, uri, fb);
      }, ms);
    }
  };
  return fb;
};

// src/main/javascript/live/nav.js
var LiveNavigationService = function() {
};
LiveNavigationService.prototype.redirect = function(_cxt, uri) {
  uri = groundUri(_cxt, uri);
  if (uri) {
    _cxt.log("redirecting to", uri);
    if (uri.toString().startsWith(window.appl.baseUri())) {
      window.history.pushState({}, "", uri);
      window.appl.gotoRoute(_cxt, uri);
    } else {
      window.location = uri;
    }
  }
};

// src/main/javascript/live/services.js
var FlasckServices = function() {
};
FlasckServices.configure = function(env) {
  env.broker.register("Ajax", new LiveAjaxService());
  env.broker.register("Navigation", new LiveNavigationService());
  window.addEventListener("popstate", function(ev) {
    console.log("location: " + document.location + ", state: " + JSON.stringify(ev.state));
    ev.preventDefault();
    window.appl.gotoRoute(env.newContext(), document.location);
  });
};
export {
  FlasckServices,
  LiveAjaxService,
  LiveNavigationService
};
