/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.zinutils.exceptions.InvalidXMLTagException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.XMLMissingAttributeException;
import org.zinutils.exceptions.XMLUnprocessedAttributeException;
import org.zinutils.xml.Location;
import org.zinutils.xml.ObjectMetaInfo;
import org.zinutils.xml.XML;
import org.zinutils.xml.XMLCompletelyHandled;
import org.zinutils.xml.XMLContextTextReceiver;
import org.zinutils.xml.XMLErrorHandler;
import org.zinutils.xml.XMLNSAttr;
import org.zinutils.xml.XMLNSTagger;
import org.zinutils.xml.XMLNamespace;
import org.zinutils.xml.XMLNotifyOnComplete;
import org.zinutils.xml.XMLTextReceiver;
import org.zinutils.xml.XMLTrackLocation;
import org.zinutils.xml.XMLWantsLocationInfo;

public class XMLElement
implements Externalizable {
    private final XML inside;
    private Element elt;
    private final HashSet<String> attrsProcessed = new HashSet();
    private XMLErrorHandler handler;

    XMLElement(XML inside, Element elt) {
        this.inside = inside;
        this.elt = elt;
    }

    public void setErrorHandler(XMLErrorHandler handler) {
        this.handler = handler;
    }

    public String tag() {
        return this.elt.getTagName();
    }

    public boolean hasTag(String tag) {
        return this.tag().equals(tag);
    }

    public void assertTag(String tag) {
        if (!tag.equals(this.tag())) {
            throw new UtilException("The element " + this + " does not have tag " + tag);
        }
    }

    public String required(String attr) {
        if (!this.elt.hasAttribute(attr)) {
            XMLMissingAttributeException ex = new XMLMissingAttributeException(this.getStartLocation(), this.getEndLocation(), "The required attribute '" + attr + "' was not found on " + this);
            if (this.handler != null) {
                this.handler.missingAttribute(this.getStartLocation(), this.getEndLocation(), ex);
            }
            throw ex;
        }
        this.attrsProcessed.add(attr);
        return this.elt.getAttribute(attr);
    }

    public void accept(String attr) {
        if (this.elt.hasAttribute(attr)) {
            this.attrsProcessed.add(attr);
        }
    }

    public String optional(String attr) {
        if (this.elt.hasAttribute(attr)) {
            this.attrsProcessed.add(attr);
            return this.elt.getAttribute(attr);
        }
        return null;
    }

    public String optional(String attr, String def) {
        if (this.elt.hasAttribute(attr)) {
            this.attrsProcessed.add(attr);
            return this.elt.getAttribute(attr);
        }
        return def;
    }

    public void attributesDone() {
        if (this.attrsProcessed.size() != this.elt.getAttributes().getLength()) {
            StringBuilder msg = new StringBuilder("At end of attributes processing for " + this.tag() + ", attributes were unprocessed:");
            XMLUnprocessedAttributeException ex = null;
            for (String a : this.attributes()) {
                if (this.attrsProcessed.contains(a)) continue;
                msg.append(" " + a);
                ex = new XMLUnprocessedAttributeException(this.getStartLocation(), this.getEndLocation(), a, msg.toString());
                if (this.handler == null) continue;
                this.handler.unprocessedAttribute(this.getStartLocation(), this.getEndLocation(), ex);
            }
            if (ex != null && this.handler == null) {
                throw ex;
            }
        }
    }

    public String get(String attr) {
        if (!this.elt.hasAttribute(attr)) {
            XMLMissingAttributeException ex = new XMLMissingAttributeException(this.getStartLocation(), this.getEndLocation(), "The required attribute '" + attr + "' was not found on " + this);
            if (this.handler != null) {
                this.handler.missingAttribute(this.getStartLocation(), this.getEndLocation(), ex);
            }
            throw ex;
        }
        return this.elt.getAttribute(attr);
    }

    public String get(String attr, String def) {
        if (this.elt.hasAttribute(attr)) {
            return this.elt.getAttribute(attr);
        }
        return def;
    }

    public List<XMLElement> elementChildren() {
        return this.elementChildren(null);
    }

    public List<XMLElement> elementChildren(String tagged) {
        ArrayList<XMLElement> ret = new ArrayList<XMLElement>();
        NodeList nl = this.elt.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || tagged != null && !((Element)n).getTagName().equals(tagged)) continue;
            XMLElement child = new XMLElement(this.inside, (Element)n);
            child.setErrorHandler(this.handler);
            ret.add(child);
        }
        return ret;
    }

    public ArrayList<Object> mixed() {
        ArrayList<Object> ret = new ArrayList<Object>();
        NodeList nl = this.elt.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                XMLElement child = new XMLElement(this.inside, (Element)n);
                child.setErrorHandler(this.handler);
                ret.add(child);
                continue;
            }
            if (!(n instanceof Text)) continue;
            ret.add(((Text)n).getData());
        }
        return ret;
    }

    public void populate(Object cxt, Object callbacks) {
        this.trackAs(cxt, this.elt);
        ObjectMetaInfo info = new ObjectMetaInfo(callbacks);
        NodeList nl = this.elt.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                XMLElement xe = new XMLElement(this.inside, (Element)n);
                this.trackAs(cxt, this.elt);
                xe.setErrorHandler(this.handler);
                try {
                    Object inner = info.dispatch(cxt, xe);
                    if (inner == null) {
                        xe.assertNoSubContents();
                        continue;
                    }
                    if (inner instanceof XMLCompletelyHandled) continue;
                    xe.populate(cxt, inner);
                    continue;
                }
                catch (InvalidXMLTagException ex) {
                    if (xe.hasHandler()) continue;
                    throw ex;
                }
                catch (XMLMissingAttributeException ex) {
                    if (xe.hasHandler()) continue;
                    throw ex;
                }
                catch (XMLUnprocessedAttributeException ex) {
                    if (xe.hasHandler()) continue;
                    throw ex;
                }
            }
            if (!(n instanceof Text) || !info.wantsText) continue;
            if (callbacks instanceof XMLContextTextReceiver) {
                ((XMLContextTextReceiver)callbacks).receiveText(cxt, ((Text)n).getData());
                continue;
            }
            if (callbacks instanceof XMLTextReceiver) {
                ((XMLTextReceiver)callbacks).receiveText(((Text)n).getData());
                continue;
            }
            throw new UtilException("There is no valid text handler");
        }
        if (callbacks instanceof XMLNotifyOnComplete) {
            this.trackAs(cxt, this.elt);
            ((XMLNotifyOnComplete)callbacks).complete(cxt);
        }
    }

    private void trackAs(Object cxt, Element lookAt) {
        if (cxt instanceof XMLTrackLocation) {
            ((XMLTrackLocation)cxt).elementLocation((Location)this.elt.getUserData("startFrom"), (Location)this.elt.getUserData("endAt"));
        }
    }

    public void assertNoSubContents() {
        NodeList nl = this.elt.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n instanceof Comment) continue;
            if (n instanceof Text) {
                String s = ((Text)n).getData();
                for (char c : s.toCharArray()) {
                    if (Character.isWhitespace(c)) continue;
                    throw new UtilException(this + " cannot have non-whitespace children");
                }
                continue;
            }
            throw new UtilException("This node cannot have " + n.getClass() + " as a child");
        }
    }

    public String toString() {
        return "XMLElement[" + this.elt.getTagName() + " @ {" + this.inside.fromResource + ":" + this.elt.getUserData("lineNumber") + "}]";
    }

    public String serialize() {
        return this.serialize(true);
    }

    public String serialize(boolean withXMLDeclaration) {
        DOMImplementationLS writer = (DOMImplementationLS)((Object)this.elt.getOwnerDocument().getImplementation());
        LSSerializer serializer = writer.createLSSerializer();
        LSOutput output = writer.createLSOutput();
        output.setEncoding("UTF-8");
        StringWriter sw = new StringWriter();
        output.setCharacterStream(sw);
        serializer.write(this.elt, output);
        if (withXMLDeclaration) {
            return sw.toString();
        }
        return sw.toString().replaceAll("<\\?[^>]*\\?>", "");
    }

    public void serializeChildrenTo(StringBuilder sb) {
        DOMImplementationLS writer = (DOMImplementationLS)((Object)this.elt.getOwnerDocument().getImplementation());
        LSSerializer serializer = writer.createLSSerializer();
        StringWriter fos = new StringWriter();
        NodeList childNodes = this.elt.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            fos.write(serializer.writeToString(childNodes.item(i)));
        }
        sb.append(fos.toString().replaceAll("<\\?[^>]*\\?>", ""));
    }

    public void serializeAttribute(StringBuilder sb, String attr) {
        Attr node = this.elt.getAttributeNode(attr);
        sb.append(attr);
        sb.append("=");
        sb.append("'");
        sb.append(node.getNodeValue());
        sb.append("'");
    }

    public String text() {
        return this.elt.getTextContent();
    }

    public String textFrom(String ... elements) {
        XMLElement e = this;
        for (String s : elements) {
            e = e.uniqueElement(s);
        }
        return e.text();
    }

    public List<String> attributes() {
        ArrayList<String> ret = new ArrayList<String>();
        NamedNodeMap attributes = this.elt.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            ret.add(((Attr)attributes.item(i)).getName());
        }
        return ret;
    }

    public XMLNamespace namespace(String ns, String url) {
        this.setAttribute("xmlns:" + ns, url);
        return new XMLNamespace(ns, url);
    }

    public XMLElement addElement(XMLNSTagger tagger) {
        return tagger.addElement(this.inside, this);
    }

    public XMLElement addElement(String tag) {
        Element child = this.inside.doc.createElement(tag);
        this.elt.appendChild(child);
        return new XMLElement(this.inside, child);
    }

    public XMLElement addElementAt(int pos, String tag) {
        Element child = this.inside.doc.createElement(tag);
        List<XMLElement> children = this.elementChildren();
        if (children.size() > 0) {
            this.elt.insertBefore(child, children.get((int)pos).elt);
        } else {
            this.elt.appendChild(child);
        }
        return new XMLElement(this.inside, child);
    }

    public void addText(String text) {
        this.elt.appendChild(this.inside.doc.createTextNode(text));
    }

    public XMLElement addElement(XMLElement xe) {
        XMLElement ret = this.addElement(xe.tag());
        for (String attr : xe.attributes()) {
            ret.setAttribute(attr, xe.get(attr));
        }
        for (XMLElement elt : xe.elementChildren()) {
            ret.addElement(elt);
        }
        return ret;
    }

    void attachElement(XMLElement ret) {
        this.elt.appendChild(ret.elt);
    }

    public void removeChild(XMLElement xe) {
        this.elt.removeChild(xe.elt);
    }

    public XMLElement setAttribute(String attr, String value) {
        this.elt.setAttribute(attr, value);
        return this;
    }

    public boolean hasAttribute(String attr) {
        return this.elt.hasAttribute(attr);
    }

    public XMLElement setAttribute(XMLNSAttr attr, String value) {
        attr.applyTo(this.elt, value);
        return this;
    }

    public XMLElement uniqueElement(String string) {
        XMLElement ret = null;
        for (XMLElement e : this.elementChildren()) {
            if (!e.hasTag(string)) continue;
            if (ret == null) {
                ret = e;
                continue;
            }
            throw new UtilException("There was more than one element tagged " + string);
        }
        if (ret != null) {
            return ret;
        }
        throw new UtilException("There was no element called " + string);
    }

    public XMLElement() {
        this.inside = new XML("1.0");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.elt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.elt = (Element)in.readObject();
    }

    public int requiredInt(String parm) {
        return Integer.parseInt(this.required(parm));
    }

    public int optionalInt(String parm, int def) {
        return Integer.parseInt(this.optional(parm, Integer.toString(def)));
    }

    public boolean requiredBoolean(String parm) {
        return Boolean.parseBoolean(this.required(parm));
    }

    public boolean optionalBoolean(String parm, boolean b) {
        return Boolean.parseBoolean(this.optional(parm, Boolean.toString(b)));
    }

    public void applyLocation(Object cxt) {
        if (cxt instanceof XMLWantsLocationInfo) {
            ((XMLWantsLocationInfo)cxt).elementLocation(this.getStartLocation(), this.getEndLocation());
        }
    }

    public Location getStartLocation() {
        return (Location)this.elt.getUserData("startFrom");
    }

    public Location getEndLocation() {
        return (Location)this.elt.getUserData("endAt");
    }

    public boolean hasHandler() {
        return this.handler != null;
    }

    public XMLErrorHandler getHandler() {
        return this.handler;
    }

    public String applyXPath(String path) {
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            XPathExpression xe = xp.compile(path);
            return (String)xe.evaluate(this.elt, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw UtilException.wrap(e);
        }
    }
}

