/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXParseException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.XMLParseException;
import org.zinutils.utils.FileUtils;
import org.zinutils.xml.LocationAnnotator;
import org.zinutils.xml.PositionalXMLReader;
import org.zinutils.xml.XMLElement;
import org.zinutils.xml.XMLErrorHandler;
import org.zinutils.xml.XMLNamespace;
import org.zinutils.xml.XMLRetainInput;

public class XML {
    Document doc;
    private XMLElement top;
    final String fromResource;
    private final LocationAnnotator annotator;
    private boolean errorsBeingCaptured;

    XML(String version) {
        this.annotator = null;
        this.fromResource = "-";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private XML(String from, InputStream stream) {
        this.annotator = new LocationAnnotator(from);
        try {
            PositionalXMLReader.readXML(stream, this.annotator);
        }
        catch (SAXParseException ex) {
            if (this.errorsBeingCaptured && this.annotator.hasErrors()) {
                this.annotator.unwindStack();
            }
            throw new XMLParseException(ex);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
        this.fromResource = from;
        this.doc = this.annotator.getDocument();
        this.top = new XMLElement(this, this.doc.getDocumentElement());
    }

    private XML(String version, String tag) {
        this.annotator = null;
        this.fromResource = "-";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
            this.doc.appendChild(this.doc.createElement(tag));
            this.top = new XMLElement(this, this.doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    XML(String version, String tag, String namespace) {
        this.annotator = null;
        this.fromResource = "-";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            DOMImplementation domImplementation = db.getDOMImplementation();
            this.doc = domImplementation.createDocument(namespace, tag, null);
            this.top = new XMLElement(this, this.doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.top.setErrorHandler(errorHandler);
        this.annotator.replayParseErrors(errorHandler);
        this.errorsBeingCaptured = true;
    }

    public static XML fromFile(File f) {
        FileInputStream fis = null;
        try {
            XML ret;
            fis = new FileInputStream(f);
            XML xML = ret = new XML(f.toString(), fis);
            return xML;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static XML fromResource(String name) {
        InputStream stream = XML.class.getResourceAsStream(name);
        if (stream == null && (stream = XML.class.getResourceAsStream("/" + name)) == null) {
            throw new UtilException("Could not find resource " + name);
        }
        return new XML(name, stream);
    }

    public static XML fromString(String s) {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        return new XML("-", is);
    }

    public static XML fromContainer(String name) {
        if (name.startsWith("resource:")) {
            return XML.fromResource(name.replace("resource:", ""));
        }
        if (name.startsWith("file:")) {
            return XML.fromFile(new File(name.replace("file:", "")));
        }
        throw new UtilException("I cannot understand the container name: " + name);
    }

    public static XML fromStream(String nameIs, InputStream stream) {
        return new XML(nameIs, stream);
    }

    public XMLElement top() {
        if (this.annotator != null && this.annotator.hasErrors()) {
            for (String s : this.annotator.getErrors()) {
                System.err.println(s);
            }
            throw this.annotator.getFirstError();
        }
        return this.top;
    }

    public static XML create(String version, String tag) {
        return new XML(version, tag);
    }

    public static XML createNS(String version, String tag, String namespace) {
        return new XML(version, tag, namespace);
    }

    public void write(File file) {
        try {
            FileUtils.assertDirectory(file.getParentFile());
            FileOutputStream fos = new FileOutputStream(file);
            this.write(fos, false);
            fos.close();
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public String prettyPrint() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos, false);
            return new String(baos.toByteArray());
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static String prettyPrint(String s) {
        try {
            return XML.fromString(s).prettyPrint();
        }
        catch (XMLParseException ex) {
            System.out.println(s);
            throw ex;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void write(OutputStream fos, boolean omitDeclaration) throws IOException {
        DOMImplementationLS writer = (DOMImplementationLS)((Object)this.doc.getImplementation());
        LSSerializer serializer = writer.createLSSerializer();
        LSOutput output = writer.createLSOutput();
        output.setEncoding("UTF-8");
        if (omitDeclaration) {
            StringWriter sw = new StringWriter();
            output.setCharacterStream(sw);
            serializer.write(this.doc.getDocumentElement(), output);
            fos.write(sw.toString().replaceAll("<\\?[^>]*\\?>", "").getBytes());
        } else {
            output.setByteStream(fos);
            serializer.write(this.doc.getDocumentElement(), output);
        }
    }

    public String asString(boolean omitDeclaration) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos, omitDeclaration);
            return new String(baos.toByteArray());
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public XMLElement addElement(String tag) {
        return this.top.addElement(tag);
    }

    public XMLElement addElementAt(int pos, String tag) {
        return this.top.addElementAt(pos, tag);
    }

    public XMLNamespace namespace(String ns, String url) {
        return this.top.namespace(ns, url);
    }

    public <T> T populate(Class<T> cls, Object cxt) {
        Object ret;
        Constructor<?> ctor = null;
        for (Constructor<?> c : cls.getConstructors()) {
            Class<?>[] args = c.getParameterTypes();
            if (args.length != 2 || !args[1].equals(XMLElement.class)) continue;
            ctor = c;
        }
        if (ctor == null) {
            throw new UtilException("There is no (Object, XMLElement) constructor for " + cls);
        }
        try {
            this.top.applyLocation(cxt);
            ret = ctor.newInstance(cxt, this.top);
        }
        catch (Exception e) {
            throw UtilException.wrap(e);
        }
        if (ret instanceof XMLRetainInput) {
            ((XMLRetainInput)ret).retainOriginalXML(this);
        }
        this.top.populate(cxt, ret);
        return (T)ret;
    }

    public String applyXPath(String path) {
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            XPathExpression xe = xp.compile(path);
            return (String)xe.evaluate(this.doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw UtilException.wrap(e);
        }
    }

    public List<XMLElement> elementChildren() {
        return this.top.elementChildren();
    }

    public List<XMLElement> elementChildren(String tagged) {
        return this.top.elementChildren(tagged);
    }

    public List<XMLElement> elementsMatching(String path) {
        ArrayList<XMLElement> ret = new ArrayList<XMLElement>();
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            XPathExpression xe = xp.compile(path);
            NodeList evaluate = (NodeList)xe.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < evaluate.getLength(); ++i) {
                Node item = evaluate.item(i);
                if (!(item instanceof Element)) {
                    throw new UtilException("Cannot return " + item + " as an element");
                }
                ret.add(new XMLElement(this, (Element)item));
            }
            return ret;
        }
        catch (XPathExpressionException e) {
            throw UtilException.wrap(e);
        }
    }

    public void delete(String path) {
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            XPathExpression xe = xp.compile(path);
            NodeList matches = (NodeList)xe.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < matches.getLength(); ++i) {
                Node item = matches.item(i);
                item.getParentNode().removeChild(item);
            }
        }
        catch (XPathExpressionException e) {
            throw UtilException.wrap(e);
        }
    }
}

