/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import org.zinutils.exceptions.UtilException;
import org.zinutils.xml.CallbackTable;
import org.zinutils.xml.XMLContextTextReceiver;
import org.zinutils.xml.XMLElement;
import org.zinutils.xml.XMLElementReceiver;
import org.zinutils.xml.XMLTextReceiver;
import org.zinutils.xml.XMLWant;
import org.zinutils.xml.XMLWants;

class ObjectMetaInfo {
    private final Object callbacks;
    public final boolean wantsText;
    private CallbackTable callbackTable;

    public ObjectMetaInfo(Object callbacks) {
        this.callbacks = callbacks;
        Class<?> clz = callbacks.getClass();
        XMLWants annotation = clz.getAnnotation(XMLWants.class);
        if (annotation != null) {
            if (annotation.value() == XMLWant.ELEMENTS) {
                this.wantsText = false;
            } else {
                if (!(callbacks instanceof XMLTextReceiver)) {
                    throw new UtilException("The class " + clz + " cannot receive text because it does not implement XMLTextReceiver");
                }
                this.wantsText = true;
            }
        } else {
            this.wantsText = callbacks instanceof XMLTextReceiver || callbacks instanceof XMLContextTextReceiver;
        }
        this.callbackTable = new CallbackTable(clz);
    }

    public Object dispatch(Object cxt, XMLElement xe) {
        if (this.callbacks instanceof XMLElementReceiver) {
            return ((XMLElementReceiver)this.callbacks).receiveElement(xe);
        }
        String tag = xe.tag().toLowerCase();
        return this.callbackTable.invoke(this.callbacks, tag, cxt, xe);
    }
}

