/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zinutils.exceptions.UtilException;

public class MarkupStreamWriter {
    private final Writer writer;
    private Mode mode = Mode.BODY;
    private final List<StackFrame> stack = new ArrayList<StackFrame>();

    public MarkupStreamWriter() {
        this.writer = new StringWriter();
    }

    public MarkupStreamWriter(Writer out) {
        this.writer = out;
    }

    public void writeStartElement(String wrapper) {
        this.mode.assertMode(Mode.BODY, Mode.BLOCKMUSTACHE);
        try {
            this.writer.append("<");
            this.writer.append(wrapper);
            this.stack.add(0, new StackFrame(this.mode, wrapper));
            this.mode = Mode.INELEMENT;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void writeAttribute(String key, String value) {
        this.mode.assertMode(Mode.INELEMENT);
        try {
            this.writer.append(" ");
            this.writer.append(key);
            this.writer.append("=\"");
            this.writer.append(this.encode(value));
            this.writer.append("\"");
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void selectBodyMode() {
        try {
            if (this.mode == Mode.INELEMENT) {
                this.writer.append(">");
                this.mode = Mode.BODY;
            } else {
                this.mode.assertMode(Mode.BODY, Mode.BLOCKMUSTACHE);
            }
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void writeCharacters(String chars) {
        try {
            this.selectBodyMode();
            this.writer.append(this.encode(chars));
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void writeEndElement() {
        if (this.stack.isEmpty()) {
            throw new UtilException("Cannot end element, since none open");
        }
        try {
            StackFrame pop = this.stack.remove(0);
            if (this.mode == Mode.INELEMENT) {
                this.writer.append("/>");
            } else {
                this.mode.assertMode(Mode.BODY);
                this.writer.append("</");
                this.writer.append(pop.label);
                this.writer.append(">");
                this.mode = pop.prev;
            }
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void closeElement() {
        if (this.stack.isEmpty()) {
            throw new UtilException("Cannot end element, since none open");
        }
        this.stack.remove(0);
    }

    public void writeMustache(String mustache) {
        try {
            if (this.mode == Mode.INELEMENT) {
                this.writer.append(" ");
            }
            this.writer.append("{{");
            this.writer.append(mustache);
            this.writer.append("}}");
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void writeBlockMustache(String header, String content) {
        try {
            this.writer.append("{{#");
            this.writer.append(header);
            this.writer.append(" ");
            this.writer.append(content);
            this.writer.append("}}");
            this.stack.add(0, new StackFrame(this.mode, header));
            this.mode = Mode.BLOCKMUSTACHE;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void writeEndMustache() {
        if (this.stack.isEmpty()) {
            throw new UtilException("Cannot end mustache, since none open");
        }
        this.mode.assertMode(Mode.BLOCKMUSTACHE);
        try {
            StackFrame pop = this.stack.remove(0);
            this.writer.append("{{/");
            this.writer.append(pop.label);
            this.writer.append("}}");
            this.mode = pop.prev;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    private CharSequence encode(String s) {
        StringBuilder ret = new StringBuilder(s);
        for (int i = 0; i < ret.length(); ++i) {
            if (ret.charAt(i) == '\"') {
                ret.replace(i, i + 1, "&quot;");
                continue;
            }
            if (ret.charAt(i) == '<') {
                ret.replace(i, i + 1, "&lt;");
                continue;
            }
            if (ret.charAt(i) == '>') {
                ret.replace(i, i + 1, "&gt;");
                continue;
            }
            if (ret.charAt(i) != '&') continue;
            ret.replace(i, i + 1, "&amp;");
        }
        return ret;
    }

    public void flush() {
    }

    public String getOutput() {
        if (this.writer instanceof StringWriter) {
            this.flush();
            return this.writer.toString();
        }
        throw new UtilException("Cannot extract string from " + this.writer);
    }

    public static enum Mode {
        BODY,
        INELEMENT,
        BLOCKMUSTACHE;


        public void assertMode(Mode ... outof) {
            for (Mode m : outof) {
                if (m != this) continue;
                return;
            }
            throw new UtilException("In mode " + this + ", not one of " + Arrays.asList(outof));
        }
    }

    public class StackFrame {
        final String label;
        final Mode prev;

        public StackFrame(Mode mode, String wrapper) {
            this.prev = mode;
            this.label = wrapper;
        }
    }
}

