/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.zinutils.exceptions.UtilException;
import org.zinutils.xml.Location;
import org.zinutils.xml.XMLErrorHandler;
import org.zinutils.xml.XMLParseError;

public class LocationAnnotator
extends DefaultHandler
implements LexicalHandler {
    static final String START_FROM = "startFrom";
    static final String END_AT = "endAt";
    private Locator locator;
    final Stack<Element> elementStack = new Stack();
    final StringBuilder textBuffer = new StringBuilder();
    private final Document doc;
    private Location last;
    private boolean debugMode = false;
    private List<XMLParseError> errors = new ArrayList<XMLParseError>();
    private final String file;

    public LocationAnnotator(String file) {
        this.file = file;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        ArrayList<String> ret = new ArrayList<String>();
        for (XMLParseError ex : this.errors) {
            ret.add(ex.toString());
        }
        return ret;
    }

    public void replayParseErrors(XMLErrorHandler errorHandler) {
        for (XMLParseError ex : this.errors) {
            errorHandler.parseError(ex);
        }
    }

    public XMLParseError getFirstError() {
        return this.errors.get(0);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private Location currentLocation() {
        return new Location(this.file, this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    private void setLast() {
        this.last = this.currentLocation();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errors.add(new XMLParseError(this.last, this.currentLocation(), e));
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errors.add(new XMLParseError(this.last, this.currentLocation(), e));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.errors.add(new XMLParseError(this.last, this.currentLocation(), e));
    }

    @Override
    public void startDocument() throws SAXException {
        this.debug("StartDoc " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.setLast();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.debug("ProcInst " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.setLast();
    }

    @Override
    public void notationDecl(String arg0, String arg1, String arg2) throws SAXException {
        this.debug("NotationDecl");
        this.setLast();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addTextIfNeeded();
        this.debug(qName + " " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        Element el = this.doc.createElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            el.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        el.setUserData(START_FROM, this.last, null);
        el.setUserData(END_AT, this.currentLocation(), null);
        this.elementStack.push(el);
        this.setLast();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedEl = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Element parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
        this.setLast();
    }

    public void unwindStack() {
        while (!this.elementStack.isEmpty()) {
            this.endElement(null, null, null);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.debug("Chars: " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.debug(new String(ch).substring(start, start + length));
        this.textBuffer.append(ch, start, length);
        this.setLast();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.debug("WS: " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.setLast();
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Element el = this.elementStack.peek();
            Text textNode = this.doc.createTextNode(this.textBuffer.toString());
            el.appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.debug("Comment " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.setLast();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.setLast();
    }

    @Override
    public void endDTD() throws SAXException {
        this.setLast();
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.setLast();
    }

    @Override
    public void startCDATA() throws SAXException {
        this.debug("StartCDATA " + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        this.setLast();
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        this.setLast();
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
        this.setLast();
    }

    private void debug(String string) {
        if (this.debugMode) {
            System.out.println(string);
        }
    }
}

