/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.zinutils.exceptions.InvalidXMLTagException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.XMLProcessingException;
import org.zinutils.xml.XMLElement;

class CallbackTable {
    private Map<String, MethodMetaInfo> callbackTable = new HashMap<String, MethodMetaInfo>();

    public CallbackTable(Class<?> clz) {
        while (clz != Object.class) {
            for (Method m : clz.getDeclaredMethods()) {
                Class<?>[] ptypes = m.getParameterTypes();
                Method method1 = null;
                Method method2 = null;
                String name = m.getName().toLowerCase();
                if (this.callbackTable.containsKey(name)) {
                    MethodMetaInfo minfo = this.callbackTable.get(name);
                    method1 = minfo.method1;
                    method2 = minfo.method2;
                }
                if (Object.class.isAssignableFrom(m.getReturnType()) && ptypes.length == 1 && ptypes[0].equals(XMLElement.class)) {
                    method1 = m;
                }
                if (Object.class.isAssignableFrom(m.getReturnType()) && ptypes.length == 2 && ptypes[1].equals(XMLElement.class)) {
                    method2 = m;
                }
                if (method1 == null && method2 == null) continue;
                this.callbackTable.put(name, new MethodMetaInfo(method1, method2));
            }
            clz = clz.getSuperclass();
        }
    }

    public Object invoke(Object callbacks, String which, Object cxt, XMLElement xe) {
        if (callbacks == null) {
            throw new UtilException("Cannot invoke " + which + " on a null object");
        }
        if (!this.callbackTable.containsKey(which)) {
            InvalidXMLTagException ex = new InvalidXMLTagException(xe, which, callbacks);
            if (xe.hasHandler()) {
                xe.getHandler().invalidTag(xe.getStartLocation(), xe.getEndLocation(), ex);
            }
            throw ex;
        }
        try {
            MethodMetaInfo minfo = this.callbackTable.get(which);
            if (minfo.method2 != null) {
                return minfo.method2.invoke(callbacks, cxt, xe);
            }
            if (minfo.method1 == null) {
                throw new UtilException("There is no invocation method for " + which + " on " + callbacks);
            }
            return minfo.method1.invoke(callbacks, xe);
        }
        catch (InvocationTargetException ex) {
            Throwable tmp = ex.getCause();
            if (tmp instanceof XMLProcessingException && xe.hasHandler()) {
                throw (RuntimeException)tmp;
            }
            throw UtilException.wrap(ex);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    static class MethodMetaInfo {
        public final Method method1;
        public final Method method2;

        public MethodMetaInfo(Method m1, Method m2) {
            this.method1 = m1;
            if (m1 != null) {
                this.method1.setAccessible(true);
            }
            this.method2 = m2;
            if (m2 != null) {
                this.method2.setAccessible(true);
            }
        }
    }
}

