/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public class ZipUtils {
    public static void copyInto(ZipArchiveOutputStream zos, File zipFile) throws FileNotFoundException, IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(ze));
                FileUtils.copyStreamWithoutClosingEither(zis, (OutputStream)zos);
                zos.closeArchiveEntry();
            }
        }
    }

    public static void fileEntry(ZipArchiveOutputStream zos, String entry, File file) throws IOException {
        zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entry));
        FileUtils.copyFileToStream(file, (OutputStream)zos);
        zos.closeArchiveEntry();
    }

    public static void fileEntry(ZipArchiveOutputStream zos, String entry, File file, int unixMode) throws IOException {
        ZipArchiveEntry zae = new ZipArchiveEntry(entry);
        zae.setUnixMode(unixMode);
        zos.putArchiveEntry((ArchiveEntry)zae);
        FileUtils.copyFileToStream(file, (OutputStream)zos);
        zos.closeArchiveEntry();
    }

    public static void fileEntryLike(ZipArchiveOutputStream zos, String entry, File indir, String pattern) throws IOException {
        List<File> options = FileUtils.findFilesMatching(indir, "*" + pattern + "*");
        int i = 0;
        while (i < options.size()) {
            if (options.get(i).isDirectory() || options.get(i).getName().contains("-sources")) {
                options.remove(i);
                continue;
            }
            ++i;
        }
        if (options.isEmpty()) {
            throw new UtilException("No files match " + pattern + " in " + indir);
        }
        if (options.size() != 1) {
            throw new UtilException("Multiple files match " + pattern + " in " + indir + ": " + options);
        }
        ZipUtils.fileEntry(zos, entry, options.get(0));
    }

    public static void directory(ZipArchiveOutputStream zos, File root) throws IOException {
        for (File f : FileUtils.findFilesMatching(root, "*")) {
            if (f.isDirectory()) continue;
            File r = FileUtils.makeRelativeTo(f, root);
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(r.getPath()));
            FileUtils.copyFileToStream(f, (OutputStream)zos);
            zos.closeArchiveEntry();
        }
    }
}

