/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileUtils;

public class ZipUpEntity
extends InputStream {
    private final Iterator<File> it;
    private InputStream curr = null;

    public ZipUpEntity(File wz) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : FileUtils.findFilesMatching(wz, "*")) {
            files.add(f);
        }
        this.it = files.iterator();
        throw new NotImplementedException("needs to actually format the stream as a Zip Stream");
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (this.curr != null || this.it.hasNext()) {
            if (this.curr != null) {
                int ret = this.curr.read(b, off, len);
                if (ret == -1) {
                    this.curr.close();
                    this.curr = null;
                } else {
                    return ret;
                }
            }
            if (!this.it.hasNext()) continue;
            File f = this.it.next();
            this.curr = new FileInputStream(f);
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        byte[] bs = new byte[1];
        int ret = this.read(bs, 0, 1);
        if (ret == 1) {
            return bs[0];
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.curr != null) {
            this.curr.close();
        }
    }
}

