/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.ZUJarException;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.ZUJarEntry;

public class ZUJarFile
implements Iterable<ZUJarEntry>,
AutoCloseable {
    private final File file;
    private JarFile jf;
    private boolean stillOpen;

    public ZUJarFile(File f) {
        try {
            this.file = FileUtils.relativePath(f);
            this.jf = new JarFile(this.file);
            this.stillOpen = true;
        }
        catch (IOException e) {
            throw new ZUJarException(f, e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.jf.getName();
    }

    @Override
    public Iterator<ZUJarEntry> iterator() {
        return new JEIterator(null);
    }

    public Iterable<ZUJarEntry> startsWith(String prefix) {
        return new JEIterable(prefix);
    }

    public InputStream getInputStream(JarEntry entry) {
        try {
            return this.jf.getInputStream(entry);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    @Override
    public void close() {
        this.stillOpen = false;
        try {
            if (this.jf != null) {
                this.jf.close();
            }
        }
        catch (IOException e) {
            throw new ZUJarException(e);
        }
    }

    public boolean isOpen() {
        return this.stillOpen;
    }

    public ZUJarEntry get(String name) {
        ZipEntry ret = this.jf.getEntry(name);
        if (ret == null || !(ret instanceof JarEntry)) {
            return null;
        }
        return new ZUJarEntry(this, (JarEntry)ret);
    }

    public ZUJarFile extractAll(File dir) {
        for (ZUJarEntry je : this) {
            if (je.isDirectory()) {
                FileUtils.assertDirectory(je.getFile());
                continue;
            }
            File f = FileUtils.combine(dir, je.getFile());
            FileUtils.assertDirectory(f.getParentFile());
            FileUtils.copyStreamToFile(je.asStream(), f);
        }
        return this;
    }

    public String toString() {
        return "[JAR: " + this.jf.getName() + "]";
    }

    class JEIterator
    implements Iterator<ZUJarEntry> {
        private Enumeration<JarEntry> en;
        private final String prefix;
        private JarEntry cuedUp;

        public JEIterator(String prefix) {
            this.en = ZUJarFile.this.jf.entries();
            this.prefix = prefix;
        }

        @Override
        public boolean hasNext() {
            if (this.cuedUp != null) {
                return true;
            }
            while (this.en.hasMoreElements()) {
                this.cuedUp = this.en.nextElement();
                if (this.prefix == null || this.cuedUp.getName().startsWith(this.prefix)) {
                    return true;
                }
                this.cuedUp = null;
            }
            return false;
        }

        @Override
        public ZUJarEntry next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            ZUJarEntry ret = new ZUJarEntry(ZUJarFile.this, this.cuedUp);
            this.cuedUp = null;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class JEIterable
    implements Iterable<ZUJarEntry> {
        private final String prefix;

        public JEIterable(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Iterator<ZUJarEntry> iterator() {
            return new JEIterator(this.prefix);
        }
    }
}

