/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.ZUJarFile;

public class ZUJarEntry {
    private final ZUJarFile jar;
    private final JarEntry entry;

    public ZUJarEntry(ZUJarFile gpJarFile, JarEntry e) {
        this.jar = gpJarFile;
        this.entry = e;
    }

    public String getPackage() {
        File parentFile = new File(this.entry.getName()).getParentFile();
        if (parentFile == null) {
            return null;
        }
        return FileUtils.convertToDottedName(parentFile);
    }

    public String getClassName() {
        return FileUtils.convertToDottedName(new File(this.entry.getName().replaceFirst(".class$", "")));
    }

    public boolean isClassFile() {
        return this.entry.getName().endsWith(".class");
    }

    public String getName() {
        return this.entry.getName();
    }

    public long length() {
        return this.entry.getSize();
    }

    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    public String toString() {
        return this.entry.toString();
    }

    public InputStream asStream() {
        return this.jar.getInputStream(this.entry);
    }

    public byte[] getBytes() {
        try {
            InputStream str = this.jar.getInputStream(this.entry);
            byte[] ret = FileUtils.readAllStream(str);
            str.close();
            return ret;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public JarEntry getJava() {
        return this.entry;
    }

    public File getFile() {
        return new File(this.getName());
    }
}

