/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.zinutils.exceptions.UtilException;

public class StringUtil {
    public static String concatVertically(List<String> errors) {
        StringBuilder sb = new StringBuilder();
        for (String s : errors) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Pattern globMatcher(String pattern) {
        StringBuilder reVersion = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '.') {
                reVersion.append("\\.");
                continue;
            }
            if (c == '?') {
                reVersion.append(".");
                continue;
            }
            if (c == '*') {
                reVersion.append(".*");
                continue;
            }
            reVersion.append(c);
        }
        return Pattern.compile(reVersion.toString());
    }

    public static boolean globMatch(String pattern, String string) {
        Pattern patt = StringUtil.globMatcher(pattern);
        return patt.matcher(string).matches();
    }

    public static String concat(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String s : args) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String concatSep(String separator, List<String> args) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String s : args) {
            sb.append(sep);
            sb.append(s);
            sep = separator;
        }
        return sb.toString();
    }

    public static String rjdigits(int quant, int nd) {
        StringBuilder sb = new StringBuilder();
        sb.append(quant);
        if (sb.length() > nd) {
            sb.delete(0, sb.length() - nd);
        }
        while (sb.length() < nd) {
            sb.insert(0, " ");
        }
        return sb.toString();
    }

    public static String digits(int quant, int nd) {
        StringBuilder sb = new StringBuilder();
        sb.append(quant);
        if (sb.length() > nd) {
            sb.delete(0, sb.length() - nd);
        }
        while (sb.length() < nd) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    public static String digits(double quant, int left, int right) {
        int dot;
        StringBuilder sb = new StringBuilder();
        sb.append(quant);
        if (sb.indexOf(".") == -1) {
            sb.append(".");
        }
        if ((dot = sb.indexOf(".")) > left) {
            sb.delete(0, dot - left);
        }
        while (dot++ < left) {
            sb.insert(0, "0");
        }
        int len = left + 1 + right;
        if (sb.length() > len) {
            sb.delete(len, sb.length());
        }
        while (sb.length() < len) {
            sb.append("0");
        }
        if (sb.indexOf(".") == -1) {
            throw new UtilException("Something went wrong");
        }
        return sb.toString();
    }

    public static String hex(long quant, int nd) {
        StringBuilder sb = new StringBuilder();
        StringUtil.hex(sb, 0, quant, nd);
        return sb.toString();
    }

    private static void hex(StringBuilder sb, int off, long quant, int nd) {
        sb.append(Long.toHexString(quant).toUpperCase());
        if (sb.length() > off + nd) {
            sb.delete(off, sb.length() - nd);
        }
        while (sb.length() < off + nd) {
            sb.insert(off, "0");
        }
    }

    public static String hex(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            StringUtil.hex(sb, i * 2, b[i] & 0xFF, 2);
        }
        return sb.toString();
    }

    public static String hex(byte[] b, int off, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            StringUtil.hex(sb, i * 2, b[off + i] & 0xFF, 2);
        }
        return sb.toString();
    }

    public static char uniqueLetter(int idx) {
        if (idx < 0) {
            return '-';
        }
        if (idx < 10) {
            return (char)(48 + idx);
        }
        if (idx < 36) {
            return (char)(65 + idx - 10);
        }
        if (idx < 62) {
            return (char)(97 + idx - 36);
        }
        if (idx < 72) {
            return (char)(33 + idx - 72);
        }
        return '+';
    }

    public static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String decapitalize(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static Iterable<String> lines(String stderr) {
        try {
            String s;
            ArrayList<String> ret = new ArrayList<String>();
            LineNumberReader lnr = new LineNumberReader(new StringReader(stderr));
            while ((s = lnr.readLine()) != null) {
                ret.add(s);
            }
            return ret;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static byte[] fromHex(String string) {
        return StringUtil.fromHex(string, string.length() / 2);
    }

    public static byte[] fromHex(String s, int len) {
        if (len != 0 && s.length() != 2 * len) {
            throw new UtilException("Invalid string length: must be " + 2 * len + " not " + s.length());
        }
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return ret;
    }

    public static boolean isHexDigit(char ch) {
        return Character.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    public static String truncate(String tmp, int columns) {
        if (tmp == null) {
            return "";
        }
        if (tmp.length() <= columns) {
            return tmp;
        }
        return tmp.substring(0, columns);
    }

    public static String join(Collection<? extends Object> object) {
        return StringUtil.join(object, " ");
    }

    public static String join(Collection<? extends Object> object, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Object object2 : object) {
            sb.append(sep);
            sb.append(object2);
            sep = separator;
        }
        return sb.toString();
    }

    public static String defaultValue(String value, String def) {
        if (value != null) {
            return value;
        }
        return def;
    }

    public static String afterLast(String value, String lookFor) {
        int idx = value.lastIndexOf(lookFor);
        if (idx == -1) {
            return value;
        }
        return value.substring(idx + lookFor.length());
    }

    public static String trimRight(String s) {
        int idx;
        for (idx = s.length(); idx > 0 && Character.isWhitespace(s.charAt(idx - 1)); --idx) {
        }
        if (idx == s.length()) {
            return s;
        }
        if (idx < 0) {
            return "";
        }
        return s.substring(0, idx);
    }

    public static String removeAllWS(String wktoken) {
        StringBuilder ret = new StringBuilder(wktoken);
        for (int i = 0; i < ret.length(); ++i) {
            if (!Character.isWhitespace(ret.charAt(i))) continue;
            ret.delete(i, i + 1);
            --i;
        }
        return ret.toString();
    }

    public static void hexdump(byte[] bs) {
        for (int i = 0; i < bs.length; i += 16) {
            int j;
            for (j = 0; j < 16; ++j) {
                if (i + j < bs.length) {
                    System.out.print(StringUtil.hex(bs[i + j], 2) + " ");
                    continue;
                }
                System.out.print("   ");
            }
            System.out.print("    ");
            for (j = 0; j < 16 && i + j < bs.length; ++j) {
                byte b = bs[i + j];
                if (b >= 32 && b < 127) {
                    System.out.print("  " + (char)b);
                    continue;
                }
                if (b > 0 && b <= 26) {
                    System.out.print(" ^" + (char)(b + 64));
                    continue;
                }
                System.out.print(" " + StringUtil.hex(b, 2));
            }
            System.out.println();
        }
    }
}

