/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.WrappedException;

public class NetworkUtils {
    static final Logger logger = LoggerFactory.getLogger((String)"NetUtils");

    public static void waitForPort(String host, int port) throws InterruptedException, IOException {
        while (true) {
            try {
                SocketChannel sock = SocketChannel.open(new InetSocketAddress(host, port));
                sock.close();
                logger.info("connected to " + host + ":" + port);
                return;
            }
            catch (ConnectException ex) {
                logger.info("Could not connect to " + host + ":" + port);
                Thread.sleep(250L);
                continue;
            }
            break;
        }
    }

    public static boolean isConnected() {
        HttpURLConnection conn = null;
        try {
            URL url = new URL("https://www.google.com");
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException e) {
            throw WrappedException.wrap(e);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

