/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.utils.LinePrinter;
import org.zinutils.utils.TextEmitter;

public class MultiTextEmitter
implements TextEmitter {
    private final List<PrintWriter> writers = new ArrayList<PrintWriter>();
    private final List<LinePrinter> lps = new ArrayList<LinePrinter>();

    public MultiTextEmitter() {
    }

    public MultiTextEmitter(PrintWriter pw) {
        this.add(pw);
    }

    public MultiTextEmitter(PrintStream out) {
        this.add(out);
    }

    public MultiTextEmitter(File file) throws FileNotFoundException {
        this.add(file);
    }

    public MultiTextEmitter(LinePrinter sw) {
        this.add(sw);
    }

    public void add(PrintWriter pw) {
        this.writers.add(pw);
    }

    public void add(File f) throws FileNotFoundException {
        this.writers.add(new PrintWriter(f));
    }

    public void add(PrintStream str) {
        this.writers.add(new PrintWriter(str));
    }

    public void add(LinePrinter sw) {
        this.lps.add(sw);
    }

    @Override
    public void print(Object o) {
        for (PrintWriter printWriter : this.writers) {
            printWriter.print(o);
            printWriter.flush();
        }
        for (LinePrinter linePrinter : this.lps) {
            linePrinter.print(o);
        }
    }

    @Override
    public void println(Object o) {
        for (PrintWriter printWriter : this.writers) {
            printWriter.println(o);
            printWriter.flush();
        }
        for (LinePrinter linePrinter : this.lps) {
            linePrinter.println(o);
        }
    }

    public void close() {
        for (PrintWriter pw : this.writers) {
            pw.close();
        }
    }

    public void showException(Exception ex) {
        for (PrintWriter pw : this.writers) {
            ex.printStackTrace(pw);
        }
    }
}

