/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Iterator;
import org.zinutils.exceptions.UtilException;

public class IterableReader
implements Iterable<String> {
    private LineNumberReader lnr;

    public IterableReader(Reader reader) {
        this.lnr = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
    }

    @Override
    public Iterator<String> iterator() {
        return new LineIterator();
    }

    private class LineIterator
    implements Iterator<String> {
        private String next;

        private LineIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            try {
                this.next = IterableReader.this.lnr.readLine();
                return this.next != null;
            }
            catch (IOException ex) {
                return false;
            }
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new UtilException("There is no next element");
            }
            String ret = this.next;
            this.next = null;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

