/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.Hollerith;
import org.zinutils.utils.HollerithField;
import org.zinutils.utils.HollerithItem;
import org.zinutils.utils.HollerithText;

public class HollerithFormat {
    private List<HollerithItem> order = new ArrayList<HollerithItem>();
    private Map<String, HollerithField> fields = new HashMap<String, HollerithField>();

    public HollerithField addField(String field) {
        if (this.hasField(field)) {
            throw new UtilException("The field " + field + " cannot be defined twice");
        }
        HollerithField f = new HollerithField(field);
        this.fields.put(field, f);
        this.order.add(f);
        return f;
    }

    public void addPadding(int i) {
        this.order.add(new HollerithText("").setWidth(i));
    }

    public void addText(String string) {
        this.order.add(new HollerithText(string).setWidth(string.length()));
    }

    public void titles(Hollerith hollerith) {
        for (Map.Entry<String, HollerithField> i : this.fields.entrySet()) {
            hollerith.set(i.getKey(), i.getValue().getHeading());
        }
    }

    public boolean hasField(String field) {
        return this.fields.containsKey(field);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("HollerithFormat{");
        for (HollerithItem e : this.order) {
            ret.append(e + ",");
        }
        ret.append("]");
        return ret.toString();
    }

    public String assemble(Map<String, String> values) {
        StringBuilder ret = new StringBuilder();
        for (HollerithItem f : this.order) {
            ret.append(f.apply(values));
        }
        return ret.toString();
    }
}

