/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.zinutils.exceptions.NoSuchDirectoryException;
import org.zinutils.exceptions.ResourceNotFoundException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.LineSeparator;
import org.zinutils.utils.StringUtil;

public class FileUtils {
    private static File root = new File(System.getProperty("user.dir"));
    private static FileFilter isdirectory = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    };
    private static FileFilter anyFile = new FileFilter(){

        @Override
        public boolean accept(File dir) {
            return true;
        }
    };
    private static Comparator<? super File> pathLengthComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            if (o1.getPath().length() > o2.getPath().length()) {
                return -1;
            }
            if (o1.getPath().length() == o2.getPath().length()) {
                return 0;
            }
            return 1;
        }
    };
    public static final Comparator<? super File> pathNameComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };

    public static void chdirAbs(File absFile) {
        try {
            if (!absFile.isDirectory()) {
                throw new UtilException("Cannot have " + absFile + " be the root directory, because it does not exist");
            }
            root = absFile;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void chdir(File parentFile) {
        try {
            File changeTo = new File(root, parentFile.getPath()).getCanonicalFile();
            if (!changeTo.isDirectory()) {
                throw new UtilException("Cannot have " + changeTo + " be the root directory, because it does not exist");
            }
            root = changeTo;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static File relativePath(String string) {
        return new File(root, string);
    }

    public static File relativePath(File f) {
        if (f.isAbsolute()) {
            return f;
        }
        try {
            return new File(root, f.getPath()).getCanonicalFile();
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static File relativePath(File qbdir, String string) {
        if (qbdir == null) {
            return new File(string);
        }
        if (qbdir.isAbsolute()) {
            return new File(qbdir, string);
        }
        return FileUtils.relativePath(new File(qbdir, string).getPath());
    }

    public static File makeRelative(File f) {
        return FileUtils.makeRelativeTo(f, root);
    }

    public static File makeRelativeTo(File f, File under) {
        if (under == null) {
            return f;
        }
        String uf = under.getPath();
        String ufSlash = uf + File.separator;
        String tf = f.getPath();
        if (uf.equals(tf)) {
            return new File("");
        }
        if (tf.startsWith(ufSlash)) {
            return new File(tf.substring(ufSlash.length()));
        }
        try {
            tf = f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UtilException("The path " + f + " does not exist");
        }
        if (uf.equals(tf)) {
            return new File("");
        }
        if (tf.startsWith(ufSlash)) {
            return new File(tf.substring(ufSlash.length()));
        }
        throw new RuntimeException("This case is not handled: " + tf + " is not a subdir of " + uf);
    }

    public static File findDirectoryNamed(String projectName) {
        File ret = new File(root, projectName);
        if (ret.isDirectory()) {
            return ret;
        }
        ret = FileUtils.findDirNamedRecursive(root, projectName);
        if (ret != null) {
            return ret;
        }
        throw new UtilException("There is no project directory: " + projectName);
    }

    private static File findDirNamedRecursive(File base, String remaining) {
        System.out.println("Looking for " + remaining + " in " + base);
        int idx = -1;
        do {
            File rec;
            if (!(rec = (idx = remaining.indexOf("-", idx + 1)) == -1 ? new File(base, remaining) : new File(base, remaining.substring(0, idx))).isDirectory()) continue;
            if (idx == -1) {
                return rec;
            }
            File ret = FileUtils.findDirNamedRecursive(rec, remaining.substring(idx + 1));
            if (ret == null) continue;
            return ret;
        } while (idx != -1);
        return null;
    }

    public static List<File> findFilesMatchingIn(File dir, String string) {
        return FileUtils.findFiles(dir, null, string, null, null, false);
    }

    public static List<File> findFilesMatchingIncluding(File dir, String string, List<File> includePackages) {
        return FileUtils.findFiles(dir, null, string, includePackages, null, true);
    }

    public static List<File> findFilesMatchingExcluding(File dir, String string, List<File> excludePackages) {
        return FileUtils.findFiles(dir, null, string, null, excludePackages, true);
    }

    public static List<File> findFilesMatching(File file, String string) {
        return FileUtils.findFiles(file, null, string, null, null, true);
    }

    public static List<File> findFilesUnderMatching(File file, String string) {
        return FileUtils.findFiles(file, file, string, null, null, true);
    }

    public static List<File> findFilesUnderRelativeToMatching(File file, File relativeTo, String string) {
        return FileUtils.findFiles(file, relativeTo, string, null, null, true);
    }

    private static List<File> findFiles(File file, File under, String string, Collection<File> includeOnlyDirs, Collection<File> excludeOnlyDirs, boolean recurse) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!file.exists()) {
            throw new NoSuchDirectoryException("There is no file " + file);
        }
        GlobFilter filter = new GlobFilter(file, string, includeOnlyDirs, excludeOnlyDirs);
        FileUtils.findRecursive(ret, filter, under, file, recurse);
        return ret;
    }

    public static List<File> findDirectoriesUnder(File dir) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!dir.exists()) {
            throw new NoSuchDirectoryException("There is no file " + dir);
        }
        FileUtils.findRecursive(ret, isdirectory, dir, dir, true);
        return ret;
    }

    private static void findRecursive(List<File> ret, FileFilter filter, File under, File dir, boolean recurse) {
        File[] contents = dir.listFiles(filter);
        if (contents == null) {
            return;
        }
        for (File f : contents) {
            ret.add(FileUtils.makeRelativeTo(f, under));
        }
        if (recurse) {
            File[] subdirs;
            for (File d : subdirs = dir.listFiles(isdirectory)) {
                FileUtils.findRecursive(ret, filter, under, d, recurse);
            }
        }
    }

    public static String convertToDottedName(File path) {
        if (path.getParent() == null) {
            return FileUtils.dropExtension(path.getName());
        }
        return FileUtils.convertToDottedName(path.getParentFile()) + "." + path.getName();
    }

    public static String convertToDottedNameDroppingExtension(File path) {
        if (path.getParent() == null) {
            return FileUtils.dropExtension(path.getName());
        }
        return FileUtils.convertToDottedName(path.getParentFile()) + "." + FileUtils.dropExtension(path.getName());
    }

    public static String extension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return name.substring(idx);
    }

    public static String dropExtension(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        return name.substring(0, idx);
    }

    public static File mavenToFile(String pkginfo) {
        String[] spl = pkginfo.split(":");
        if (spl == null || spl.length != 4) {
            throw new UtilException("'" + pkginfo + "' is not a valid maven package name");
        }
        return FileUtils.fileConcat(FileUtils.convertDottedToPath(spl[0]).getPath(), spl[1], spl[3], spl[1] + "-" + spl[3] + "." + spl[2]);
    }

    public static File convertDottedToPathWithExtension(String clz, String ext) {
        File wo = FileUtils.convertDottedToPath(clz);
        return FileUtils.combine(wo.getParentFile(), wo.getName() + ext);
    }

    public static File convertDottedToPath(String pkg) {
        String[] spl = pkg.split("\\.");
        return FileUtils.fileConcat(spl);
    }

    public static String convertDottedToSlashPath(String pkg) {
        String[] spl = pkg.split("\\.");
        Object ret = "";
        for (String s : spl) {
            ret = (String)ret + "/" + s;
        }
        return ((String)ret).substring(1);
    }

    public static File fileConcat(String ... spl) {
        File ret = null;
        for (String s : spl) {
            if (s == null) continue;
            ret = ret == null ? new File(s) : new File(ret, s);
        }
        if (ret == null) {
            throw new UtilException("Could not concatenate " + Arrays.toString(spl));
        }
        return ret;
    }

    public static String urlPath(String root, File mavenToFile) {
        if (mavenToFile == null) {
            if (root.endsWith("/")) {
                return root.substring(0, root.length() - 1);
            }
            return root;
        }
        return FileUtils.urlPath(root, mavenToFile.getParentFile()) + "/" + mavenToFile.getName();
    }

    public static void copyFileToStream(File from, OutputStream to) {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(from);
                FileUtils.copyStream(is, to);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static File copyStreamToTempFile(InputStream is) {
        try {
            File tmp = File.createTempFile("copy", "out");
            tmp.deleteOnExit();
            FileUtils.copyStreamToFile(is, tmp);
            return tmp;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void copyStreamToFile(InputStream is, File outFile) {
        try (FileOutputStream to = new FileOutputStream(outFile);){
            FileUtils.copyStream(is, to);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void copyStreamToFileWithoutClosing(InputStream is, File outFile) {
        try (FileOutputStream to = new FileOutputStream(outFile);){
            FileUtils.copyStreamWithoutClosingEither(is, to);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream to) throws IOException {
        FileUtils.copyStreamWithoutClosingEither(inputStream, to);
        inputStream.close();
    }

    public static void copyStreamWithoutClosingEither(InputStream inputStream, OutputStream to) throws IOException {
        byte[] bs = new byte[500];
        int cnt = 0;
        while ((cnt = inputStream.read(bs, 0, 500)) > 0) {
            to.write(bs, 0, cnt);
        }
        to.flush();
    }

    public static String readResource(String resourceName) {
        InputStream stream = FileUtils.class.getResourceAsStream(resourceName);
        if (stream == null) {
            if (!resourceName.startsWith("/")) {
                stream = FileUtils.class.getResourceAsStream("/" + resourceName);
            }
            if (stream == null) {
                throw new ResourceNotFoundException("Could not find resource " + resourceName);
            }
        }
        String ret = new String(FileUtils.readAllStream(stream));
        try {
            stream.close();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
        return ret;
    }

    public static byte[] readAllStream(InputStream asStream) {
        try {
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = asStream.read()) >= 0) {
                baos.write(b);
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static byte[] readAllReader(Reader r) {
        try {
            int cnt;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            char[] cbuf = new char[500];
            while ((cnt = r.read(cbuf, 0, 500)) > 0) {
                baos.write(new String(cbuf, 0, cnt).getBytes());
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static String readAllReaderAsString(Reader reader) {
        try {
            int cnt;
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[500];
            while ((cnt = reader.read(cbuf, 0, 500)) > 0) {
                sw.write(cbuf, 0, cnt);
            }
            return sw.toString();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static String readNStream(long contentLength, InputStream inputStream) {
        if (contentLength == 0L) {
            return "";
        }
        if (contentLength > 0L) {
            return FileUtils.readNReader(contentLength, new InputStreamReader(inputStream));
        }
        return FileUtils.readAllReaderAsString(new InputStreamReader(inputStream));
    }

    public static byte[] readOffsetStream(InputStream is, int offset, int length) {
        byte[] tmp = new byte[1000];
        byte[] ret = new byte[length];
        try {
            int pos;
            int cnt;
            for (pos = 0; pos < offset && (cnt = is.read(tmp, 0, offset - pos)) >= 0; pos += cnt) {
            }
            if (pos == -1) {
                return null;
            }
            for (pos = 0; pos < length && (cnt = is.read(ret, pos, length - pos)) >= 0; pos += cnt) {
            }
            if (pos == length) {
                return ret;
            }
            tmp = new byte[pos];
            for (int i = 0; i < pos; ++i) {
                tmp[i] = ret[i];
            }
            return tmp;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    private static String readNReader(long inCnt, Reader r) {
        int cnt = (int)inCnt;
        try {
            int n;
            char[] cbuf = new char[cnt];
            for (int pos = 0; pos < cnt && (n = r.read(cbuf, pos, cnt - pos)) > 0; pos += n) {
            }
            return new String(cbuf);
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void writeToStream(String string, OutputStream outputStream) {
        try {
            outputStream.write(string.getBytes());
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void assertDirectory(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new UtilException("Cannot create directory " + file);
        }
        if (!file.isDirectory()) {
            throw new UtilException("File '" + file + "' is not a directory");
        }
    }

    public static void assertFile(File file) {
        if (!file.exists()) {
            FileUtils.writeFile(file, "");
        }
    }

    public static File getCurrentDir() {
        return root;
    }

    public static void cleanDirectory(File dir) {
        ArrayList<File> ret = new ArrayList<File>();
        FileUtils.findRecursive(ret, anyFile, dir, dir, true);
        Collections.sort(ret, pathLengthComparator);
        for (File f : ret) {
            if (new File(dir, f.getPath()).delete()) continue;
            throw new UtilException("Could not delete: " + f);
        }
    }

    public static void persistentCleanDirectory(File bindir, int numberOfRetries, int msToWaitBetweenTries) {
        try {
            FileUtils.cleanDirectory(bindir);
        }
        catch (UtilException ex) {
            if (numberOfRetries > 0) {
                System.out.println(ex.getMessage() + " Retrying in " + msToWaitBetweenTries + "ms");
                FileUtils.persistentCleanDirectory(bindir, numberOfRetries - 1, msToWaitBetweenTries);
            }
            throw new UtilException("Not able to sucessfully delete " + bindir);
        }
    }

    public static void deleteDirectoryTree(File dir) {
        FileUtils.cleanDirectory(dir);
        dir.delete();
    }

    public static File combine(Object ... paths) {
        File ret = null;
        if (paths[0] instanceof File) {
            ret = (File)paths[0];
        } else if (paths[0] instanceof String) {
            ret = new File((String)paths[0]);
        }
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i] instanceof File) {
                ret = FileUtils.combine(ret, (File)paths[i]);
                continue;
            }
            if (!(paths[i] instanceof String)) continue;
            ret = FileUtils.combine(ret, (String)paths[i]);
        }
        return ret;
    }

    public static File combine(File path1, String path2) {
        if (path1 == null && path2 == null) {
            return null;
        }
        if (path1 == null) {
            return new File(path2);
        }
        if (path2 == null) {
            return path1;
        }
        return new File(path1, path2);
    }

    public static File combine(File path1, File path2) {
        if (path1 == null && path2 == null) {
            return null;
        }
        if (path1 == null) {
            return path2;
        }
        if (path2 == null) {
            return path1;
        }
        return new File(path1, path2.getPath());
    }

    public static File combine(String path1, String path2) {
        if (path1 == null) {
            return FileUtils.combine((File)null, path2);
        }
        return FileUtils.combine(new File(path1), path2);
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw UtilException.wrap(e);
        }
    }

    public static void cat(File file) {
        try {
            String s;
            LineNumberReader lnr = new LineNumberReader(new FileReader(file));
            while ((s = lnr.readLine()) != null) {
                System.out.println(s);
            }
            lnr.close();
        }
        catch (IOException e) {
            throw UtilException.wrap(e);
        }
    }

    public static String getUnextendedName(File file) {
        String ret = file.getName();
        if (ret.indexOf(".") == -1) {
            return ret;
        }
        return ret.substring(0, ret.indexOf("."));
    }

    public static String getPackage(File file) {
        if (file.getParentFile() == null) {
            return "";
        }
        return FileUtils.convertToDottedName(file.getParentFile());
    }

    public static void copyAssertingDirs(File from, File to) {
        FileUtils.assertDirectory(to.getParentFile());
        FileUtils.copy(from, to);
    }

    public static void copyRecursive(File from, File to) {
        if (from == null) {
            return;
        }
        FileUtils.assertDirectory(to);
        File[] toCopy = from.listFiles();
        if (toCopy == null || toCopy.length == 0) {
            return;
        }
        int nerrors = 0;
        for (File f : toCopy) {
            try {
                File f2 = new File(to, f.getName());
                if (f.isDirectory()) {
                    FileUtils.copyRecursive(f, f2);
                    continue;
                }
                FileUtils.copy(f, f2);
            }
            catch (Exception ex) {
                ++nerrors;
            }
        }
        if (nerrors > 0) {
            throw new UtilException("Encountered " + nerrors + " copying " + from + " to " + to);
        }
    }

    public static void appendToFile(File in, File appendTo) {
        if (appendTo.isDirectory()) {
            appendTo = new File(appendTo, in.getName());
        }
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(appendTo, true);
            FileUtils.copyStream(fis, fos);
            fis.close();
            fos.close();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void copy(File f, File f2) {
        if (f2.isDirectory()) {
            f2 = new File(f2, f.getName());
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            FileOutputStream fos = new FileOutputStream(f2);
            FileUtils.copyStream(fis, fos);
            fis.close();
            fos.close();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static String clean(String name) {
        int i;
        StringBuilder ret = new StringBuilder(name);
        for (i = 0; i < ret.length(); ++i) {
            char c = ret.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '_') continue;
            if (c == '-') {
                ret.setCharAt(i, '_');
                continue;
            }
            ret.setCharAt(i, '.');
        }
        while (ret.length() > 0 && ret.charAt(0) == '.') {
            ret.deleteCharAt(0);
        }
        for (i = ret.length() - 1; i >= 0 && ret.charAt(i) == '.'; --i) {
            ret.deleteCharAt(i);
        }
        if (ret.length() == 0) {
            throw new RuntimeException("Cleaned " + name + " completely away");
        }
        if (ret.length() > 180) {
            ret.delete(180, ret.length());
        }
        return ret.toString();
    }

    public static Set<File> directorySet(Iterable<File> sourceFiles) {
        HashSet<File> ret = new HashSet<File>();
        for (File f : sourceFiles) {
            ret.add(f.getParentFile());
        }
        return ret;
    }

    public static File ensureExtension(File f, String ext) {
        return new File(f.getParentFile(), FileUtils.ensureExtension(f.getName(), ext));
    }

    public static String ensureExtension(String name, String ext) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(ext)) {
            return name;
        }
        int idx = name.lastIndexOf(".");
        if (idx == -1) {
            return name + ext;
        }
        return name.substring(0, idx) + ext;
    }

    public static boolean isUnder(File file, File under) {
        try {
            String s = file.getCanonicalPath();
            String u = under.getCanonicalPath();
            return s.startsWith(u);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File moveRelativeRoot(File tmp, File from, File to) {
        if (!FileUtils.isUnder(tmp, from)) {
            throw new UtilException(tmp + " is not under " + from);
        }
        File ret = FileUtils.makeRelativeTo(tmp, from);
        return new File(to, ret.getPath());
    }

    public static boolean isUpToDate(File copy, File orig) {
        return copy.lastModified() >= orig.lastModified();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFile(File f) {
        try (FileInputStream fis = new FileInputStream(f);){
            String string;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));){
                String s;
                LineSeparator separator = FileUtils.detectLineSeparator(f);
                StringBuffer sb = new StringBuffer();
                while ((s = br.readLine()) != null) {
                    sb.append(s + separator);
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void writeFile(File f, byte[] decrypted) {
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(decrypted);
        }
        catch (IOException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static void writeFile(File f, Collection<String> lines) {
        try (FileOutputStream fos = new FileOutputStream(f);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));){
            for (String l : lines) {
                bw.write(l);
                bw.write(10);
            }
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static void writeFile(File f, String content) {
        BufferedWriter bw = null;
        try {
            FileOutputStream fos = new FileOutputStream(f);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(content);
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {
                    throw UtilException.wrap(ex);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFileAsLines(File f) {
        ArrayList<String> ret = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(f);){
            ArrayList<String> arrayList;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));){
                String s;
                while ((s = br.readLine()) != null) {
                    ret.add(s);
                }
                arrayList = ret;
            }
            return arrayList;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    /*
     * Exception decompiling
     */
    private static LineSeparator detectLineSeparator(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] readFileAsBytes(File f, boolean blockUntilAvailable) {
        if (blockUntilAvailable) {
            try {
                int timeout = 10000;
                int shortDuration = 50;
                long timeoutTime = System.currentTimeMillis() + (long)timeout;
                while (!f.canRead() && System.currentTimeMillis() < timeoutTime) {
                    Thread.sleep(shortDuration);
                }
                FileInputStream inputStream = null;
                while (inputStream == null) {
                    try {
                        inputStream = new FileInputStream(f);
                    }
                    catch (Exception exception) {
                        if (System.currentTimeMillis() < timeoutTime) {
                            Thread.sleep(shortDuration);
                            continue;
                        }
                        throw exception;
                    }
                }
                inputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
                return FileUtils.toByteArray(inputStream);
            }
            catch (Exception exception) {
                throw UtilException.wrap(exception);
            }
        }
        return FileUtils.readFileAsBytes(f);
    }

    public static byte[] readFileAsBytes(File f) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            byte[] byArray = FileUtils.toByteArray(fis);
            return byArray;
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    throw UtilException.wrap(ex);
                }
            }
        }
    }

    private static byte[] toByteArray(FileInputStream fis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copyStream(fis, baos);
        return baos.toByteArray();
    }

    public static String posixPath(File path) {
        return path.getPath().replaceAll("\\\\", "/");
    }

    public static void createFile(File file, String contents) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayInputStream bais = new ByteArrayInputStream(contents.getBytes());
            FileUtils.copyStream(bais, fos);
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            throw UtilException.wrap(ex);
        }
    }

    public static List<File> splitJavaPath(String path) {
        String[] elts = path.split(File.pathSeparator);
        ArrayList<File> ret = new ArrayList<File>();
        for (String s : elts) {
            if (s == null || s.length() == 0) continue;
            try {
                File pe = FileUtils.relativePath(new File(s)).getCanonicalFile();
                if (!pe.exists()) continue;
                ret.add(pe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static File canonical(String dir) {
        try {
            return new File(dir).getCanonicalFile();
        }
        catch (IOException e) {
            throw UtilException.wrap(e);
        }
    }

    public static void dumpStream(InputStream str) throws IOException {
        int cnt;
        byte[] bs = new byte[16];
        while ((cnt = str.read(bs)) != -1) {
            for (int i = 0; i < cnt; ++i) {
                if (bs[i] >= 32 && bs[i] < 127) {
                    System.out.print((char)bs[i]);
                    continue;
                }
                if (bs[i] == 9) {
                    System.out.print("\\t");
                    continue;
                }
                if (bs[i] == 10) {
                    System.out.println("\\n");
                    continue;
                }
                if (bs[i] == 13) {
                    System.out.print("\\r");
                    continue;
                }
                System.out.print("#" + StringUtil.hex(bs[i], 2));
            }
        }
        str.close();
    }

    public static int compare(File oldcf, File newcf) throws IOException {
        if (oldcf.length() < newcf.length()) {
            return -1;
        }
        if (oldcf.length() > newcf.length()) {
            return 1;
        }
        try (LineNumberReader left = new LineNumberReader(new FileReader(oldcf));
             LineNumberReader right = new LineNumberReader(new FileReader(newcf));){
            while (true) {
                int n;
                String l = left.readLine();
                String r = right.readLine();
                if (l == null && r == null) {
                    n = 0;
                    return n;
                }
                if (l == null) {
                    n = -1;
                    return n;
                }
                if (r == null) {
                    n = 1;
                    return n;
                }
                int cmp = l.compareTo(r);
                if (cmp == 0) continue;
                int n2 = cmp;
                return n2;
            }
        }
    }

    public static List<String> pathElements(File f) {
        ArrayList<String> ret = new ArrayList<String>();
        FileUtils.pathElements(ret, f);
        return ret;
    }

    private static void pathElements(List<String> ret, File f) {
        if (f.getParentFile() != null) {
            FileUtils.pathElements(ret, f.getParentFile());
        }
        ret.add(f.getName());
    }

    public static File figureRelativePathFrom(File base, File full) {
        int i;
        List<String> b = FileUtils.pathElements(base);
        List<String> f = FileUtils.pathElements(full);
        for (i = 0; i < b.size() && b.get(i).equals(f.get(i)); ++i) {
        }
        File r = null;
        for (int j = i; j < b.size(); ++j) {
            r = new File(r, "..");
        }
        while (i < f.size()) {
            r = new File(r, f.get(i++));
        }
        return r;
    }

    public static class GlobFilter
    implements FileFilter {
        private final String pattern;
        private final Collection<File> includeOnlyDirs;
        private final Collection<File> excludeOnlyDirs;
        private final File rootdir;

        public GlobFilter(File file, String pattern, Collection<File> includeOnlyDirs, Collection<File> excludeOnlyDirs) {
            this.rootdir = FileUtils.relativePath(file);
            this.pattern = pattern;
            this.includeOnlyDirs = this.roundUp(includeOnlyDirs);
            this.excludeOnlyDirs = this.roundUp(excludeOnlyDirs);
        }

        private Collection<File> roundUp(Collection<File> dirs) {
            if (dirs == null) {
                return null;
            }
            ArrayList<File> ret = new ArrayList<File>();
            for (File f : dirs) {
                File from = FileUtils.relativePath(this.rootdir, f.getPath());
                if (!from.isDirectory()) continue;
                ret.add(FileUtils.makeRelativeTo(from, this.rootdir));
                for (File d : FileUtils.findDirectoriesUnder(from)) {
                    ret.add(FileUtils.makeRelativeTo(FileUtils.relativePath(from, d.getPath()), this.rootdir));
                }
            }
            return ret;
        }

        @Override
        public boolean accept(File f) {
            File relativeParent = FileUtils.makeRelativeTo(f.getParentFile(), this.rootdir);
            return !(!StringUtil.globMatch(this.pattern, f.getName()) || this.includeOnlyDirs != null && !this.includeOnlyDirs.contains(relativeParent) || this.excludeOnlyDirs != null && this.excludeOnlyDirs.contains(relativeParent));
        }
    }
}

