/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Random;
import org.jasypt.util.text.BasicTextEncryptor;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.StringUtil;

public class Crypto {
    private static Random r = new Random();

    public static String generateSalt() {
        return StringUtil.digits(r.nextInt(10000), 4);
    }

    public static String storePassword(String password, String salt) {
        return Crypto.hash(salt + password);
    }

    public static String hash(String str) {
        return StringUtil.hex(Crypto.computeHash(str.getBytes()));
    }

    public static byte[] computeHash(String str) {
        return Crypto.computeHash(str.getBytes());
    }

    public static String hash(byte[] bs) {
        return StringUtil.hex(Crypto.computeHash(bs));
    }

    public static byte[] computeHash(byte[] bs) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-1");
            d.reset();
            d.update(bs);
            return d.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw UtilException.wrap(e);
        }
    }

    public static String hash(File f) {
        return StringUtil.hex(Crypto.computeHash(f));
    }

    public static String hashTrim(File f) {
        return StringUtil.hex(Crypto.computeHashTrim(f));
    }

    public static byte[] computeHash(File f) {
        return Crypto.computeHashWith(f, "SHA-1");
    }

    public static byte[] computeHashTrim(File f) {
        return Crypto.computeHashTrimWith(f, "SHA-1");
    }

    public static String hash256(File f) {
        return StringUtil.hex(Crypto.computeHash256(f));
    }

    public static byte[] computeHash256(File f) {
        return Crypto.computeHashWith(f, "SHA-256");
    }

    private static byte[] computeHashWith(File f, String algorithm) {
        FileInputStream fis = null;
        try {
            int n;
            MessageDigest d = MessageDigest.getInstance(algorithm);
            d.reset();
            byte[] bs = new byte[5000];
            fis = new FileInputStream(f);
            while ((n = fis.read(bs)) != -1) {
                d.update(bs, 0, n);
            }
            byte[] byArray = d.digest();
            return byArray;
        }
        catch (Exception e) {
            throw UtilException.wrap(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] computeHashTrimWith(File f, String algorithm) {
        byte[] byArray;
        LineNumberReader lnr = new LineNumberReader(new FileReader(f));
        try {
            String ln;
            MessageDigest d = MessageDigest.getInstance(algorithm);
            d.reset();
            while ((ln = lnr.readLine()) != null) {
                byte[] bs = ln.trim().getBytes();
                d.update(bs, 0, bs.length);
            }
            byArray = d.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lnr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw UtilException.wrap(e);
            }
        }
        lnr.close();
        return byArray;
    }

    public static String encrypt(String password, String text) {
        BasicTextEncryptor bte = new BasicTextEncryptor();
        bte.setPassword(password);
        return bte.encrypt(text);
    }

    public static String decrypt(String password, String text) {
        BasicTextEncryptor bte = new BasicTextEncryptor();
        bte.setPassword(password);
        return bte.decrypt(text);
    }

    public static String makeSignature(PrivateKey key, String data) {
        try {
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(key);
            signer.update(data.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(signer.sign());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static String signatureForStream(PrivateKey key, InputStream is, boolean closeStream) {
        try {
            int cnt;
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(key);
            byte[] bs = new byte[5000];
            while ((cnt = is.read(bs)) > 0) {
                signer.update(bs, 0, cnt);
            }
            return Base64.getEncoder().encodeToString(signer.sign());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] argv) {
        for (String s : argv) {
            System.out.println(s + ": " + Crypto.hash(s));
        }
    }
}

