/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.exceptions.UtilException;
import org.zinutils.parser.LinePatternMatch;
import org.zinutils.parser.LinePatternParser;
import org.zinutils.system.ProcessOutReader;

public class ThreadedStreamReader
extends Thread
implements ProcessOutReader {
    private final OutputStream writeTo;
    private final List<LPPMatcher> matchers = new ArrayList<LPPMatcher>();
    private File readFile;
    private InputStream readFrom;
    private boolean doEcho;
    private FileOutputStream copyTo;
    private StringBuilder buffer = new StringBuilder();

    public ThreadedStreamReader() {
        this.writeTo = null;
    }

    public ThreadedStreamReader(OutputStream out) {
        this.writeTo = out;
    }

    @Override
    public void run() {
        if (this.readFrom == null && this.readFile != null) {
            try {
                this.readFrom = new FileInputStream(this.readFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            byte[] bs = new byte[400];
            int cnt = 0;
            while ((cnt = this.readFrom.read(bs, 0, bs.length)) > 0) {
                if (this.writeTo != null) {
                    this.writeTo.write(bs, 0, cnt);
                    this.writeTo.flush();
                }
                if (this.doEcho) {
                    System.out.write(bs, 0, cnt);
                    System.out.flush();
                }
                if (this.copyTo != null) {
                    this.copyTo.write(bs, 0, cnt);
                    this.copyTo.flush();
                }
                for (String s : this.completeLines(bs, cnt)) {
                    for (LPPMatcher lpm : this.matchers) {
                        ArrayList<LinePatternMatch> ret = new ArrayList<LinePatternMatch>();
                        lpm.lpp.applyTo(ret, s);
                        for (LinePatternMatch m : ret) {
                            lpm.iterator.handleMatch(m);
                        }
                    }
                }
            }
            this.readFrom.close();
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Stream closed")) {
                return;
            }
            throw UtilException.wrap(ex);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    private List<String> completeLines(byte[] bs, int cnt) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < cnt; ++i) {
            char c = (char)bs[i];
            if (c == '\n') {
                ret.add(this.buffer.toString());
                this.buffer.delete(0, this.buffer.length());
                continue;
            }
            if (c == '\r') continue;
            this.buffer.append(c);
        }
        return ret;
    }

    @Override
    public void echoStream(boolean doEcho) {
        this.doEcho = doEcho;
    }

    public void copyTo(File file) {
        try {
            this.copyTo = new FileOutputStream(file);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    public void appendTo(File file) {
        try {
            this.copyTo = new FileOutputStream(file, true);
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    @Override
    public void read(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        this.readFrom = inputStream;
    }

    public void read(File f) {
        this.readFile = f;
    }

    public void parseLines(LinePatternParser lpp, LinePatternParser.MatchIterator iterator) {
        this.matchers.add(new LPPMatcher(lpp, iterator));
    }

    public class LPPMatcher {
        private final LinePatternParser lpp;
        private final LinePatternParser.MatchIterator iterator;

        public LPPMatcher(LinePatternParser lpp, LinePatternParser.MatchIterator iterator) {
            this.lpp = lpp;
            this.iterator = iterator;
        }
    }
}

