/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zinutils.exceptions.UtilException;
import org.zinutils.system.ProcessOutReader;
import org.zinutils.system.ThreadedStreamReader;
import org.zinutils.system.WaitForThread;
import org.zinutils.utils.FileUtils;

public class RunProcess {
    private final List<String> cmdarray = new ArrayList<String>();
    private int preClassPos = -1;
    private boolean clearEnv;
    private final Map<String, String> envMap = new HashMap<String, String>();
    private File workingDir = null;
    private InputStream stdin;
    private ProcessOutReader stdout;
    private ProcessOutReader stderr;
    private int exitCode;
    private ByteArrayOutputStream outCapture;
    private ByteArrayOutputStream errCapture;
    private boolean finished;
    private boolean showArgs;
    private boolean debug;
    private boolean runBackground;
    private Process proc;
    private Thread hook;
    private boolean willSendInput;
    private OutputStream inputStream;

    public RunProcess(File cmd) {
        this(cmd.getPath());
    }

    public RunProcess(String cmd) {
        this.cmdarray.add(cmd);
        this.stdout = new ThreadedStreamReader();
        this.stderr = new ThreadedStreamReader();
    }

    public void arg(String string) {
        this.cmdarray.add(string);
    }

    public void arg(File file) {
        this.cmdarray.add(file.getPath());
    }

    public void preClassArg(String string) {
        if (this.preClassPos == -1) {
            throw new UtilException("Can only use preClassArg with java command");
        }
        this.cmdarray.add(this.preClassPos++, string);
    }

    public void clearEnv(boolean b) {
        this.clearEnv = b;
    }

    public void env(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.envMap.put(key, value);
    }

    public void env(String key, File dir) {
        this.env(key, dir.getPath());
    }

    public void env(String key, int k) {
        this.env(key, Integer.toString(k));
    }

    public void env(String key, boolean b) {
        this.env(key, Boolean.toString(b));
    }

    public void readFrom(InputStream is) {
        this.stdin = is;
    }

    public void redirectStdout(OutputStream out) {
        this.stdout = new ThreadedStreamReader(out);
    }

    public void redirectStderr(OutputStream err) {
        this.stderr = new ThreadedStreamReader(err);
    }

    public void discardStdout() {
        this.stdout = new ThreadedStreamReader();
    }

    public void discardStderr() {
        this.stderr = new ThreadedStreamReader();
    }

    public void processStdout(ProcessOutReader out) {
        this.stdout = out;
    }

    public void processStderr(ProcessOutReader err) {
        this.stderr = err;
    }

    public ProcessOutReader captureStdout() {
        this.outCapture = new ByteArrayOutputStream();
        this.stdout = new ThreadedStreamReader(this.outCapture);
        return this.stdout;
    }

    public ProcessOutReader captureStderr() {
        this.errCapture = new ByteArrayOutputStream();
        this.stderr = new ThreadedStreamReader(this.errCapture);
        return this.stderr;
    }

    public void willSendInput() {
        this.willSendInput = true;
    }

    public void showArgs(boolean b) {
        this.showArgs = b;
    }

    public void background(boolean b) {
        this.runBackground = b;
    }

    public void executeInDir(File inDir) {
        this.workingDir = inDir;
    }

    public void execute() {
        if (this.showArgs) {
            for (String s : this.cmdarray) {
                System.out.println(s);
            }
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(this.cmdarray);
            Map<String, String> env = builder.environment();
            if (this.clearEnv) {
                env.clear();
            }
            env.putAll(this.envMap);
            builder.directory(this.workingDir);
            this.proc = builder.start();
            this.stderr.echoStream(this.showArgs);
            this.stdout.read(this.proc.getInputStream());
            this.stdout.start();
            this.stderr.read(this.proc.getErrorStream());
            this.stderr.start();
            this.hook = new Thread(){

                @Override
                public void run() {
                    if (RunProcess.this.proc != null) {
                        RunProcess.this.proc.destroy();
                        RunProcess.this.proc = null;
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.hook);
            if (this.runBackground) {
                new WaitForThread(this).start();
                if (this.stdin != null) {
                    final OutputStream sendIt = this.proc.getOutputStream();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                FileUtils.copyStream(RunProcess.this.stdin, sendIt);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }.start();
                } else if (this.willSendInput) {
                    this.inputStream = this.proc.getOutputStream();
                }
                return;
            }
            if (this.stdin != null) {
                FileUtils.copyStream(this.stdin, this.proc.getOutputStream());
            } else if (this.willSendInput) {
                this.inputStream = this.proc.getOutputStream();
            }
            this.waitForEnd();
        }
        catch (Exception e) {
            throw UtilException.wrap(e);
        }
    }

    public OutputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEnd() throws InterruptedException {
        this.exitCode = this.proc.waitFor();
        this.stdout.join();
        this.stderr.join();
        if (this.debug) {
            if (this.outCapture != null) {
                System.out.println(this.outCapture);
            }
            if (this.errCapture != null) {
                System.out.println(this.errCapture);
            }
        }
        if (this.debug) {
            System.out.println("Process terminated");
        }
        RunProcess runProcess = this;
        synchronized (runProcess) {
            this.finished = true;
        }
    }

    public int getExitCode() {
        this.assertFinished();
        return this.exitCode;
    }

    public InputStream getStdoutStream() {
        this.assertFinished();
        if (this.outCapture == null) {
            throw new UtilException("Can only call this if output was captured during setup");
        }
        return new ByteArrayInputStream(this.outCapture.toByteArray());
    }

    public String getStdout() {
        this.assertFinished();
        if (this.outCapture == null) {
            throw new UtilException("Can only call this if output was captured during setup");
        }
        return this.outCapture.toString();
    }

    public InputStream getStderrStream() {
        this.assertFinished();
        if (this.errCapture == null) {
            throw new UtilException("Can only call this if errors were captured during setup");
        }
        return new ByteArrayInputStream(this.errCapture.toByteArray());
    }

    public String getStderr() {
        this.assertFinished();
        if (this.errCapture == null) {
            throw new UtilException("Can only call this if errors were captured during setup");
        }
        return this.errCapture.toString();
    }

    public Reader stdoutReader() {
        return new StringReader(this.getStdout());
    }

    public Reader stderrReader() {
        return new StringReader(this.getStderr());
    }

    private synchronized void assertFinished() {
        if (!this.finished) {
            throw new UtilException("Can only call this method after successful completion");
        }
    }

    public void debug(boolean showDebug) {
        if (showDebug) {
            this.debug = true;
            this.showArgs(true);
            this.redirectStderr(System.out);
            this.redirectStdout(System.out);
        }
    }

    public List<String> getArgs() {
        return this.cmdarray;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public void kill() {
        if (this.finished || this.proc == null) {
            return;
        }
        if (this.debug) {
            System.out.println("Killing " + this.proc);
        }
        this.proc.destroy();
        while (true) {
            try {
                this.exitCode = this.proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.finished = true;
    }

    public static RunProcess childJava(Class<?> cls) {
        Object path = "java";
        String jh = System.getProperty("java.home");
        if (jh != null) {
            path = jh + "/bin/java";
        }
        RunProcess ret = new RunProcess((String)path);
        ret.arg("-classpath");
        ret.arg(System.getProperty("java.class.path"));
        ret.preClassPos = ret.cmdarray.size();
        ret.arg(cls.getName());
        return ret;
    }

    public void destroy() {
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
        if (this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
            this.hook = null;
        }
    }

    public String toString() {
        return "RunProcess[" + this.cmdarray.get(0) + "]";
    }
}

