/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.sync;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.zinutils.exceptions.WrappedException;

public class MR1WMap<T> {
    private final Supplier<T> producer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, T> map = new TreeMap<String, T>();

    public MR1WMap(Supplier<T> producer) {
        this.producer = producer;
    }

    public T get(String key) {
        this.lock.readLock().lock();
        try {
            T t = this.map.get(key);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T create(String key) {
        this.lock.writeLock().lock();
        try {
            if (this.map.containsKey(key)) {
                T t = this.map.get(key);
                return t;
            }
            T ret = this.producer.get();
            this.map.put(key, ret);
            T t = ret;
            return t;
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

