/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.sync;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;

public class LockingCounter {
    private static final Logger logger = LoggerFactory.getLogger((String)"Utils");
    private final AtomicInteger counter = new AtomicInteger(0);
    String patienceChild = System.getProperty("org.flasck.patience.child");
    boolean wantTimeout = this.patienceChild == null || !this.patienceChild.equals("true");
    private RuntimeException ex;

    public void start(String reason) {
        if (this.counter.get() != 0) {
            throw new CantHappenException("the counter is not 0 at start() but " + this.counter.get());
        }
        this.counter.set(1);
        logger.info("reset counter from 0 to 1 for " + reason);
    }

    public void end(String name) {
        int cnt = this.counter.decrementAndGet();
        logger.info("end of " + name + ": " + cnt);
    }

    public void waitForZero(int timeout, TimeUnit unit) throws TimeoutException {
        this.waitForZero((int)TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForZero(int ms) throws TimeoutException {
        logger.info("going to wait for " + ms + " for locking counter, currently with " + this.counter.get());
        Date d = new Date(new Date().getTime() + (long)ms);
        while (this.counter.get() != 0) {
            try {
                LockingCounter lockingCounter = this;
                synchronized (lockingCounter) {
                    this.wait(ms);
                }
                logger.info("wait ended with locking counter at " + this.counter.get());
                if (!this.wantTimeout || !new Date().after(d)) continue;
                logger.error("locking counter timed out with counter " + this.counter.get() + " at " + new Date() + " waiting until " + d);
                throw new TimeoutException();
            }
            catch (InterruptedException ex) {
                logger.warn("interrupted while waiting for lock until " + d + " but continuing ...");
            }
        }
        logger.info("counter = " + this.counter.get());
        if (this.ex != null) {
            RuntimeException tex = this.ex;
            this.ex = null;
            throw tex;
        }
    }

    public boolean isZero() {
        return this.counter.get() == 0;
    }

    public void raise(RuntimeException ex) {
        this.ex = ex;
    }

    public void lock(String string) {
        int cnt = this.counter.incrementAndGet();
        logger.info("LOCK " + string + ": after cnt = " + cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String string) {
        logger.info("RELEASE " + string + ": before cnt = " + this.counter.get());
        int dec = this.counter.decrementAndGet();
        LockingCounter lockingCounter = this;
        synchronized (lockingCounter) {
            if (dec == 0) {
                logger.info("NOTIFY others");
                this.notify();
            }
        }
    }

    public int getCount() {
        return this.counter.get();
    }
}

