/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger((String)"Dispatcher");
    public final List<Runnable> tasks = new ArrayList<Runnable>();

    @Override
    public synchronized void execute(Runnable command) {
        logger.info("Adding task " + command);
        this.tasks.add(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.tasks.isEmpty()) {
            return;
        }
        int processed = 0;
        logger.info("Flushing tasks " + this.tasks.size());
        while (true) {
            Runnable t;
            DispatchExecutor dispatchExecutor = this;
            synchronized (dispatchExecutor) {
                if (this.tasks.isEmpty()) {
                    break;
                }
                t = this.tasks.remove(0);
            }
            t.run();
            ++processed;
        }
        logger.info("Flushed tasks " + processed);
    }
}

