/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.reflection.Item0Creator;
import org.zinutils.reflection.Item1Creator;
import org.zinutils.reflection.Item2Creator;
import org.zinutils.reflection.Item4Creator;

public class Reflection {
    public static <T> T getStaticField(Class<?> inClz, String fieldName) {
        try {
            Field f = inClz.getDeclaredField(fieldName);
            if (f == null) {
                throw new RuntimeException("The field '" + fieldName + "' was not defined in " + inClz);
            }
            f.setAccessible(true);
            return (T)f.get(null);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static Field getFieldVar(Class<?> cls, String fieldName) {
        if (cls == null) {
            throw new RuntimeException("Cannot use reflection on null class");
        }
        if (fieldName == null) {
            throw new RuntimeException("Must specify a valid field name");
        }
        Field f = Reflection.findField(cls, fieldName);
        if (f == null) {
            throw new RuntimeException("The field '" + fieldName + "' was not defined in " + cls);
        }
        f.setAccessible(true);
        return f;
    }

    public static <T> T getField(Object target, String fieldName) {
        try {
            if (target == null) {
                throw new RuntimeException("Cannot use reflection on null object");
            }
            Class<?> clz = target.getClass();
            Field f = Reflection.getFieldVar(clz, fieldName);
            return (T)f.get(target);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static Class<?> fieldType(Object target, String fieldName) {
        try {
            if (target == null) {
                throw new RuntimeException("Cannot use reflection on null object");
            }
            Class<?> clz = target.getClass();
            Field f = Reflection.getFieldVar(clz, fieldName);
            return f.getType();
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static void setField(Object target, String fieldName, Object value) {
        block17: {
            try {
                if (target == null) {
                    throw new RuntimeException("Cannot use reflection on null object");
                }
                if (fieldName == null) {
                    throw new RuntimeException("Must specify a valid field name");
                }
                Class<?> clz = target.getClass();
                Field f = Reflection.findField(clz, fieldName);
                if (f == null) {
                    throw new RuntimeException("The field '" + fieldName + "' was not defined in " + target.getClass());
                }
                f.setAccessible(true);
                if (value instanceof Boolean) {
                    f.setBoolean(target, (Boolean)value);
                    break block17;
                }
                if (f.getType().getName().equals("boolean")) {
                    f.setBoolean(target, Boolean.parseBoolean((String)value));
                    break block17;
                }
                if (f.getType().getName().equals("int") || f.getType().getName().equals("java.lang.Integer")) {
                    int k;
                    if (value instanceof String) {
                        k = Integer.parseInt((String)value);
                    } else if (value instanceof Integer) {
                        k = (Integer)value;
                    } else {
                        throw new RuntimeException("Cannot cast " + value.getClass() + " to integer");
                    }
                    if (f.getType().getName().equals("int")) {
                        f.setInt(target, k);
                    } else {
                        f.set(target, k);
                    }
                    break block17;
                }
                if (value == null || f.getType().isAssignableFrom(value.getClass())) {
                    f.set(target, value);
                    break block17;
                }
                if (value != null && Collection.class.isAssignableFrom(f.getType())) {
                    Collection coll = (Collection)f.get(target);
                    if (coll == null) {
                        throw new RuntimeException("The collection in field '" + fieldName + "' has not been initialized");
                    }
                    coll.add(value);
                    break block17;
                }
                throw new RuntimeException("The field " + fieldName + " is not assignable from " + value.getClass());
            }
            catch (Exception ex) {
                throw Reflection.wrapException(ex);
            }
        }
    }

    public static boolean hasField(Object obj, String f) {
        return Reflection.findField(obj.getClass(), f) != null;
    }

    private static Field findField(Class<?> clz, String fieldName) {
        try {
            return clz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException fex) {
            if (clz.getSuperclass() != null) {
                return Reflection.findField(clz.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    public static <T> T create(ClassLoader loader, String cls, Object ... args) {
        try {
            Class<?> clz = loader != null ? Class.forName(cls, false, loader) : Class.forName(cls);
            return (T)Reflection.create(clz, args);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static <T> T create(Class<T> clz, Object ... args) {
        try {
            Jimmy<T>[] constructors = Reflection.wrap(clz.getDeclaredConstructors());
            return Reflection.match(clz, "constructor", constructors, args).invoke(args);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static <O, T> T call(O invokee, String meth, Object ... args) {
        try {
            Class<?> clz = invokee.getClass();
            Jimmy<T>[] methods = Reflection.wrap(invokee, clz, meth);
            return Reflection.match(clz, meth, methods, args).invoke(args);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static Object call(Object invokee, Method meth, Object ... args) {
        try {
            return meth.invoke((Object)args, new Object[0]);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static <O, T> Jimmy<T> findMethod(O invokee, String meth, Object ... args) {
        try {
            Class<?> clz = invokee.getClass();
            Jimmy<T>[] methods = Reflection.wrap(invokee, clz, meth);
            return Reflection.match(clz, meth, methods, args);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <O> void callSetter(O invokee, String property, Object value) {
        String meth = "set" + WordUtils.capitalize((String)property);
        Reflection.call(invokee, meth, value);
    }

    public static <T> T callStatic(ClassLoader loader, String cls, String meth, Object ... args) {
        try {
            Class<?> clz = loader != null ? Class.forName(cls, false, loader) : Class.forName(cls);
            return Reflection.callStatic(clz, meth, args);
        }
        catch (ClassNotFoundException ex) {
            throw Reflection.wrapException(ex);
        }
    }

    public static <O, T> T callStatic(Class<O> clz, String meth, Object ... args) {
        try {
            Jimmy<T>[] methods = Reflection.wrap(clz, meth);
            return Reflection.match(clz, "static " + meth, methods, args).invoke(args);
        }
        catch (Exception ex) {
            throw Reflection.wrapException(ex);
        }
    }

    private static <O, T> Jimmy<T> match(Class<O> clz, String what, Jimmy<T>[] jimmies, Object[] args) {
        ArrayList<Jimmy<T>> matching = new ArrayList<Jimmy<T>>();
        block0: for (Jimmy<T> j : jimmies) {
            Class<?>[] jtypes;
            if (j instanceof BJimmy && !matching.isEmpty()) break;
            if (j instanceof BJimmy || args.length != (jtypes = j.getTypes()).length) continue;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null && !jtypes[i].isInstance(args[i]) && (!jtypes[i].getSimpleName().equals("boolean") || !(args[i] instanceof Boolean)) && (!jtypes[i].getSimpleName().equals("int") || !(args[i] instanceof Integer))) continue block0;
            }
            matching.add(j);
        }
        if (matching.isEmpty()) {
            throw new RuntimeException("There is no matching method '" + what + "' in class '" + clz.getName() + "' with " + Reflection.showArgs(args));
        }
        if (matching.size() > 1) {
            throw new RuntimeException("Ambiguous '" + what + "' in class '" + clz.getName() + "' with " + Reflection.showArgs(args) + ": " + matching);
        }
        return (Jimmy)matching.get(0);
    }

    private static String showArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return "no args";
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : args) {
            if (o == null) {
                ret.add("null");
                continue;
            }
            if (o instanceof String) {
                ret.add("\"" + o + "\"");
                continue;
            }
            if (o instanceof String) {
                ret.add("\"" + o + "\"");
                continue;
            }
            if (o instanceof Integer) {
                ret.add(Integer.toString((Integer)o));
                continue;
            }
            ret.add(o.getClass().getName());
        }
        return ((Object)ret).toString();
    }

    private static <T> Jimmy<T>[] wrap(Constructor<?>[] constructors) {
        CJimmy[] ret = new CJimmy[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            ret[i] = new CJimmy(constructors[i]);
        }
        return ret;
    }

    private static <O, T> Jimmy<T>[] wrap(O invokee, Class<O> clz, String meth) {
        ArrayList acc = new ArrayList();
        for (Class<O> curr = clz; curr != null; curr = curr.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = curr.getDeclaredMethods()) {
                if (!m.getName().equals(meth) || (m.getModifiers() & 0x400) != 0) continue;
                acc.add(new MJimmy(invokee, m));
            }
            acc.add(new BJimmy());
        }
        Jimmy[] ret = acc.toArray(new Jimmy[acc.size()]);
        return ret;
    }

    private static <O, T> Jimmy<T>[] wrap(Class<O> clz, String meth) {
        ArrayList acc = new ArrayList();
        for (Class<O> curr = clz; curr != null; curr = curr.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = curr.getDeclaredMethods()) {
                if (!m.getName().equals(meth)) continue;
                acc.add(new SJimmy(clz, m));
            }
        }
        Jimmy[] ret = acc.toArray(new Jimmy[acc.size()]);
        return ret;
    }

    public static Map<Field, Object> allFields(Object inpf) {
        HashMap<Field, Object> ret = new HashMap<Field, Object>();
        if (inpf == null) {
            return ret;
        }
        for (Class<?> clz = inpf.getClass(); clz != Object.class; clz = clz.getSuperclass()) {
            for (Field f : clz.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    ret.put(f, f.get(inpf));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static RuntimeException wrapException(Exception ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new WrappedException(ex);
    }

    public static List<Method> methods(Object clz, String method) {
        Method[] declaredMethods = clz.getClass().getDeclaredMethods();
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method m : declaredMethods) {
            if (!m.getName().equals(method)) continue;
            ret.add(m);
        }
        return ret;
    }

    public static <T> Item0Creator<? extends T> creator0(final Class<T> cls) {
        return new Item0Creator<T>(){

            @Override
            public T create() {
                return Reflection.create(cls, new Object[0]);
            }
        };
    }

    public static <T, U> Item1Creator<? extends T, ? super U> creator1(final Class<T> cls1, Class<? super U> cls2) {
        return new Item1Creator<T, U>(){

            @Override
            public T create(U u) {
                return Reflection.create(cls1, u);
            }
        };
    }

    public static <T, U, V> Item2Creator<? extends T, ? super U, ? super V> creator2(final Class<T> cls1, Class<? super U> cls2, Class<? super V> cls3) {
        return new Item2Creator<T, U, V>(){

            @Override
            public T create(U u, V v) {
                return Reflection.create(cls1, u, v);
            }
        };
    }

    public static <T, U, V, W, X> Item4Creator<? extends T, ? super U, ? super V, ? super W, ? super X> creator4(final Class<T> cls1, Class<? super U> cls2, Class<? super V> cls3, Class<? super W> cls4, Class<? super X> cls5) {
        return new Item4Creator<T, U, V, W, X>(){

            @Override
            public T create(U u, V v, W w, X x) {
                return Reflection.create(cls1, u, v, w, x);
            }
        };
    }

    public static Method getFirstMethod(Class<?> clz, String name) {
        Method[] ms;
        for (Method m : ms = clz.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Set<Class<?>> allInterfaces(Class<?> cls) {
        HashSet ret = new HashSet();
        Reflection.figureAllInterfaces(cls, ret);
        return ret;
    }

    private static void figureAllInterfaces(Class<?> cls, Set<Class<?>> ret) {
        for (Class<?> i : cls.getInterfaces()) {
            ret.add(i);
            Reflection.figureAllInterfaces(i, ret);
        }
        if (cls.getSuperclass() != null) {
            Reflection.figureAllInterfaces(cls.getSuperclass(), ret);
        }
    }

    public static interface Jimmy<T> {
        public T invoke(Object[] var1) throws Exception;

        public Class<?>[] getTypes();
    }

    public static class BJimmy<T>
    implements Jimmy<T> {
        @Override
        public T invoke(Object[] args) throws Exception {
            throw new NotImplementedException();
        }

        @Override
        public Class<?>[] getTypes() {
            return null;
        }
    }

    public static class CJimmy<T>
    implements Jimmy<T> {
        private final Constructor<T> constructor;

        public CJimmy(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Class<?>[] getTypes() {
            return this.constructor.getParameterTypes();
        }

        @Override
        public T invoke(Object[] args) throws Exception {
            this.constructor.setAccessible(true);
            return this.constructor.newInstance(args);
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    public static class MJimmy<O, T>
    implements Jimmy<T> {
        private final Method method;
        private final O invokee;

        public MJimmy(O invokee, Method method) {
            this.invokee = invokee;
            this.method = method;
        }

        @Override
        public Class<?>[] getTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public T invoke(Object[] args) throws Exception {
            this.method.setAccessible(true);
            return (T)this.method.invoke(this.invokee, args);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    public static class SJimmy<O, T>
    implements Jimmy<T> {
        private final Class<O> clz;
        private final Method m;

        public SJimmy(Class<O> clz, Method m) {
            this.clz = clz;
            this.m = m;
        }

        @Override
        public T invoke(Object[] args) throws Exception {
            this.m.setAccessible(true);
            return (T)this.m.invoke(this.clz, args);
        }

        @Override
        public Class<?>[] getTypes() {
            return this.m.getParameterTypes();
        }
    }
}

