/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.zinutils.exceptions.UtilException;

public class LinePatternMatch {
    private Map<String, String> contents = new HashMap<String, String>();
    private final String id;

    public LinePatternMatch(Matcher m, String id, String[] storeIn) {
        this.id = id;
        int cnt = 2;
        for (String s : storeIn) {
            try {
                this.contents.put(s, m.group(cnt++));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new UtilException("Could not extract field " + s + " for rule " + id + " because there were not " + (cnt - 2) + " patterns: ", ex);
            }
        }
    }

    public boolean is(String string) {
        return this.id.equals(string);
    }

    public String get(String string) {
        if (!this.contents.containsKey(string)) {
            throw new UtilException("No element " + string + " was captured");
        }
        return this.contents.get(string);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id = " + this.id);
        sb.append(" match = " + this.contents);
        return sb.toString();
    }
}

