/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import org.zinutils.utils.StringUtil;

public class QuotedPrintableCodec {
    private final Consumer<byte[]> to;
    private final ByteArrayOutputStream tmp = new ByteArrayOutputStream();

    public QuotedPrintableCodec(Consumer<byte[]> to) {
        this.to = to;
    }

    public void encode(byte[] bs) throws IOException {
        for (int i = 0; i < bs.length; ++i) {
            byte b = bs[i];
            if (b == 61) {
                this.tmp.write(new byte[]{61, 51, 68});
            } else if (b == 9 || b >= 32 && b <= 126) {
                this.tmp.write(b);
            } else if (b == 10 || b == 13) {
                this.handleTrailingWS();
                this.tmp.write(b);
            } else {
                byte[] t1 = StringUtil.hex(b, 2).getBytes();
                this.tmp.write(new byte[]{61, t1[0], t1[1]});
            }
            if (this.tmp.size() < 73) continue;
            this.tmp.write(new byte[]{61, 13, 10});
            this.to.accept(this.tmp.toByteArray());
            this.tmp.reset();
        }
    }

    public void decode(byte[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            byte b = bs[i];
            if (b == 61) {
                if (i + 2 > bs.length) continue;
                byte b1 = bs[++i];
                byte b2 = bs[++i];
                if (b1 == 13 && b2 == 10) continue;
                byte[] n = StringUtil.fromHex(new String(new byte[]{b1, b2}));
                this.tmp.write(n[0]);
                continue;
            }
            this.tmp.write(b);
        }
        if (this.tmp.size() > 0) {
            this.to.accept(this.tmp.toByteArray());
            this.tmp.reset();
        }
    }

    public void doneEncoding() throws IOException {
        if (this.tmp.size() > 0) {
            this.handleTrailingWS();
            this.to.accept(this.tmp.toByteArray());
        }
    }

    public void doneDecoding() {
    }

    private void handleTrailingWS() throws IOException {
        byte[] bs;
        int tl = this.tmp.size();
        if (tl > 0 && ((bs = this.tmp.toByteArray())[tl - 1] == 32 || bs[tl - 1] == 9)) {
            this.tmp.reset();
            this.tmp.write(bs, 0, tl - 1);
            this.tmp.write(61);
            if (bs[tl - 1] == 32) {
                this.tmp.write(new byte[]{50, 48});
            } else {
                this.tmp.write(new byte[]{48, 57});
            }
        }
    }
}

