/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.mime;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.function.Consumer;

public class Base64Codec {
    private final Consumer<byte[]> to;
    private final Base64.Encoder encoder;
    private final Base64.Decoder decoder;

    public Base64Codec(Consumer<byte[]> to) {
        this.to = to;
        this.encoder = Base64.getEncoder();
        this.decoder = Base64.getDecoder();
    }

    public void encode(byte[] bs) {
        this.to.accept(this.encoder.encode(bs));
    }

    public void decode(byte[] bs) throws UnsupportedEncodingException {
        if (bs == null) {
            return;
        }
        this.to.accept(this.decoder.decode(new String(bs).trim()));
    }

    public void doneEncoding() {
    }

    public void doneDecoding() {
    }
}

