/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.filters;

import java.io.IOException;
import java.io.Serializable;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLSupportImpl;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.inabox.grizzly.actors.Role;
import org.zinutils.inabox.grizzly.events.AcceptCompleteEvent;
import org.zinutils.inabox.grizzly.events.ConnectionReadyEvent;
import org.zinutils.inabox.grizzly.events.SwitchToSSLEvent;
import org.zinutils.inabox.grizzly.filters.AcceptorProcessorCreatorFilter;

public class RuntimeSSLFilter
extends SSLFilter {
    public static final Logger logger = LoggerFactory.getLogger((String)"inabox.Grizzly");
    final Attribute<Boolean> CONNECTION_IS_SECURE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(RuntimeSSLFilter.class.getName() + "_secure");
    final Attribute<FilterChainContext> HandshakeComplete = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(RuntimeSSLFilter.class.getName() + "_handshake");
    private final Role role;
    private final String host;
    private final int port;
    private final boolean alwaysSSL;

    public RuntimeSSLFilter(boolean alwaysSSL, Role role, SSLEngineConfigurator sslConfig, String host, int port) {
        super((SSLEngineConfigurator)(role == Role.SERVER ? sslConfig : null), (SSLEngineConfigurator)(role == Role.CLIENT ? sslConfig : null));
        this.alwaysSSL = alwaysSSL;
        this.role = role;
        this.host = host;
        this.port = port;
        if (role == Role.SERVER) {
            this.addHandshakeListener(new SSLBaseFilter.HandshakeListener(){

                public void onStart(Connection arg0) {
                }

                public void onFailure(Connection arg0, Throwable arg1) {
                    logger.error("Handshake failed", arg1);
                }

                public void onComplete(Connection arg0) {
                    logger.debug("TLS handshake completed on " + arg0);
                    SSLSupportImpl support = new SSLSupportImpl(arg0);
                    try {
                        Object[] chain = support.getPeerCertificateChain();
                        logger.debug("chain = " + (Serializable)(chain == null ? "none" : Integer.valueOf(chain.length)));
                    }
                    catch (IOException e) {
                        logger.error("Error processing packets", (Throwable)e);
                    }
                    FilterChainContext c1 = (FilterChainContext)RuntimeSSLFilter.this.HandshakeComplete.get((AttributeStorage)arg0);
                    if (c1 != null) {
                        c1.notifyUpstream((FilterChainEvent)new ConnectionReadyEvent());
                        RuntimeSSLFilter.this.HandshakeComplete.remove((AttributeStorage)arg0);
                    }
                }
            });
        }
    }

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        logger.info("SSL has accept with " + this.alwaysSSL);
        if (this.alwaysSSL) {
            this.CONNECTION_IS_SECURE.set((AttributeStorage)ctx.getConnection(), (Object)true);
            this.HandshakeComplete.set((AttributeStorage)ctx.getConnection(), (Object)ctx.copy());
            return super.handleAccept(ctx);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Boolean sslState = (Boolean)this.CONNECTION_IS_SECURE.get((AttributeStorage)ctx.getConnection());
        logger.debug(this.role + " has received message, with " + sslState);
        if (sslState != null) {
            return super.handleRead(ctx);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Boolean sslState = (Boolean)this.CONNECTION_IS_SECURE.get((AttributeStorage)ctx.getConnection());
        logger.debug(this.role + " is writing, with " + sslState);
        if (sslState != null) {
            return super.handleWrite(ctx);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event instanceof SwitchToSSLEvent) {
            logger.debug(this.role + " initiating SSL handshake now");
            Connection conn = ctx.getConnection();
            this.CONNECTION_IS_SECURE.set((AttributeStorage)conn, (Object)true);
            if (this.role.equals((Object)Role.CLIENT)) {
                SSLEngine sslEngine = this.getClientSSLEngineConfigurator().createSSLEngine(this.host, this.port);
                sslEngine.beginHandshake();
                SSLUtils.setSSLEngine((Connection)ctx.getConnection(), (SSLEngine)sslEngine);
            } else if (this.role.equals((Object)Role.SERVER)) {
                SSLEngine sslEngine = this.getServerSSLEngineConfigurator().createSSLEngine();
                SSLUtils.setSSLEngine((Connection)ctx.getConnection(), (SSLEngine)sslEngine);
            }
            logger.info(this.role + " returning STOP");
            return ctx.getStopAction();
        }
        if (event instanceof AcceptCompleteEvent) {
            logger.info("Saw accept complete event with " + this.alwaysSSL);
            if (!this.alwaysSSL) {
                FilterChain chain = ctx.getFilterChain();
                AcceptorProcessorCreatorFilter lh = (AcceptorProcessorCreatorFilter)((Object)chain.get(4));
                lh.onConnectionReady(ctx.getConnection());
            }
            return ctx.getInvokeAction();
        }
        return super.handleEvent(ctx, event);
    }

    public boolean isAlwaysSSL() {
        return this.alwaysSSL;
    }

    public void doHandshake(Connection<?> connection) throws IOException {
        this.CONNECTION_IS_SECURE.set(connection, (Object)true);
        this.handshake(connection, (CompletionHandler)new CompletionHandler<SSLEngine>(){

            public void updated(SSLEngine arg0) {
                logger.info("updated " + arg0);
            }

            public void failed(Throwable arg0) {
                logger.error("failed " + arg0);
            }

            public void completed(SSLEngine arg0) {
                logger.info("completed " + arg0);
            }

            public void cancelled() {
                logger.warn("cancelled");
            }
        });
    }
}

