/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.inabox.grizzly.filters.SuppressLineBreaks;

public class LineBreakFilter
extends BaseFilter {
    public static final Logger logger = LoggerFactory.getLogger((String)"inabox.Grizzly");
    private boolean lineBreaks;
    private boolean seenCR;

    public LineBreakFilter(boolean lineBreaks) {
        this.lineBreaks = lineBreaks;
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        ByteBuffer bb;
        Object msg = ctx.getMessage();
        boolean sendCRLF = this.lineBreaks;
        if (msg instanceof ByteBuffer) {
            bb = (ByteBuffer)msg;
        } else {
            if (msg instanceof SuppressLineBreaks) {
                msg = ((SuppressLineBreaks)msg).getMessage();
                sendCRLF = false;
            }
            Object send = (String)msg;
            logger.debug("Sending " + (String)send);
            if (sendCRLF) {
                send = (String)send + "\r\n";
            }
            bb = ByteBuffer.wrap(((String)send).getBytes());
        }
        ByteBufferWrapper m = new ByteBufferWrapper(bb);
        ctx.setMessage((Object)m);
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            Object msg = ctx.getMessage();
            if (msg instanceof Buffer) {
                Buffer buf = (Buffer)msg;
                if (!this.lineBreaks) {
                    byte[] bs = new byte[buf.remaining()];
                    buf.get(bs);
                    ctx.setMessage((Object)new String(bs));
                    return ctx.getInvokeAction();
                }
                int pos = buf.position();
                while (buf.hasRemaining()) {
                    byte b = buf.get();
                    if (b == 13) {
                        this.seenCR = true;
                        continue;
                    }
                    if (this.seenCR && b == 10) {
                        int end = buf.position() - 2;
                        buf.position(pos);
                        byte[] bs = new byte[end - pos];
                        buf.get(bs);
                        buf.position(buf.position() + 2);
                        String str = new String(bs);
                        ctx.setMessage((Object)str);
                        if (buf.hasRemaining()) {
                            return ctx.getInvokeAction((Object)buf);
                        }
                        return ctx.getInvokeAction();
                    }
                    this.seenCR = false;
                }
                buf.position(pos);
                return ctx.getStopAction((Object)buf);
            }
            return ctx.getStopAction();
        }
        catch (Exception ex) {
            logger.error("Exception breaking into lines", (Throwable)ex);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            return ctx.getStopAction();
        }
    }
}

