/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.filters;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.zinutils.inabox.grizzly.ResponseHandler;
import org.zinutils.inabox.grizzly.events.SwitchToSSLEvent;
import org.zinutils.inabox.grizzly.filters.SuppressLineBreaks;

public class GrizzlyResponseHandler
implements ResponseHandler {
    private final Connection<?> connection;

    public GrizzlyResponseHandler(Connection<?> connection) {
        this.connection = connection;
    }

    @Override
    public void process(String msg) {
        this.connection.write((Object)msg);
    }

    @Override
    public void processNoLineBreak(String msg) {
        this.connection.write((Object)new SuppressLineBreaks(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStream(InputStream stream) throws IOException {
        try {
            int cnt = 0;
            byte[] bs = new byte[1000];
            while ((cnt = stream.read(bs)) != -1) {
                this.connection.write((Object)ByteBuffer.wrap(bs, 0, cnt));
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void enterTLSMode() {
        GrizzlyResponseHandler.moveToTLS(this.connection);
    }

    public static void moveToTLS(Connection<?> conn) {
        FilterChain p = (FilterChain)conn.obtainProcessor(IOEvent.WRITE);
        FilterChainContext ctx = p.obtainFilterChainContext(conn);
        ctx.setFilterIdx(p.size());
        ctx.notifyDownstream((FilterChainEvent)new SwitchToSSLEvent());
    }

    @Override
    public void close() {
        this.connection.closeSilently();
    }
}

