/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.filters;

import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.inabox.grizzly.AcceptorProcessor;
import org.zinutils.inabox.grizzly.LineProcessor;
import org.zinutils.inabox.grizzly.events.AcceptCompleteEvent;
import org.zinutils.inabox.grizzly.events.ConnectionReadyEvent;
import org.zinutils.inabox.grizzly.filters.GrizzlyResponseHandler;

public class AcceptorProcessorCreatorFilter
extends BaseFilter {
    public static final Logger logger = LoggerFactory.getLogger((String)"inabox.Grizzly");
    private final Attribute<LineProcessor> lineProcessor = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(AcceptorProcessorCreatorFilter.class.getName());
    private AcceptorProcessor acceptor;

    public AcceptorProcessorCreatorFilter(AcceptorProcessor acceptor) {
        this.acceptor = acceptor;
    }

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        logger.info("Accepting connection from " + ctx.getConnection().getPeerAddress() + " on " + ctx.getConnection().getLocalAddress());
        ctx.notifyDownstream((FilterChainEvent)new AcceptCompleteEvent());
        return super.handleAccept(ctx);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        LineProcessor proc = (LineProcessor)this.lineProcessor.get((AttributeStorage)ctx.getConnection());
        proc.process((String)ctx.getMessage());
        return ctx.getStopAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        logger.debug("Connection closed: from " + ctx.getConnection().getPeerAddress() + " on " + ctx.getConnection().getLocalAddress());
        try {
            ctx.getConnection().close().get();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return ctx.getStopAction();
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event instanceof ConnectionReadyEvent) {
            this.onConnectionReady(ctx.getConnection());
        }
        return ctx.getInvokeAction();
    }

    public void onConnectionReady(Connection<?> conn) {
        logger.info("Opening accepted connection from " + conn.getPeerAddress() + " on " + conn.getLocalAddress());
        LineProcessor proc = this.acceptor.connect(new GrizzlyResponseHandler(conn));
        if (proc == null) {
            throw new CantHappenException("the acceptor returned a null connection");
        }
        this.lineProcessor.set(conn, (Object)proc);
    }
}

