/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.actors;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.inabox.grizzly.ResponseHandler;
import org.zinutils.inabox.grizzly.actors.GrizzlyBuilder;
import org.zinutils.inabox.grizzly.actors.Role;
import org.zinutils.inabox.grizzly.filters.AcceptorProcessorCreatorFilter;
import org.zinutils.inabox.grizzly.filters.ClientLineHandler;
import org.zinutils.inabox.grizzly.filters.GrizzlyResponseHandler;
import org.zinutils.inabox.grizzly.filters.LineBreakFilter;
import org.zinutils.inabox.grizzly.filters.LoggerFilter;
import org.zinutils.inabox.grizzly.filters.ReplyLineProcessor;
import org.zinutils.inabox.grizzly.filters.RuntimeSSLFilter;

public class GrizzlyEndpoint
implements ResponseHandler {
    public static final Logger logger = LoggerFactory.getLogger((String)"inabox.Grizzly");
    private TCPNIOTransport transport;
    private Connection<?> connection;
    private final FilterChainBuilder filterChainBuilder;
    private final RuntimeSSLFilter sslFilter;
    private final Role role;
    private int port;

    public GrizzlyEndpoint(GrizzlyBuilder builder) throws Exception {
        this.role = builder.role;
        this.port = builder.port;
        this.filterChainBuilder = FilterChainBuilder.stateless();
        this.filterChainBuilder.add((Filter)new TransportFilter());
        this.sslFilter = new RuntimeSSLFilter(builder.alwaysSSL, builder.role, builder.sslConfig, builder.host, builder.port);
        this.filterChainBuilder.add((Filter)this.sslFilter);
        this.filterChainBuilder.add((Filter)new LineBreakFilter(builder.addBreaks));
        this.filterChainBuilder.add((Filter)new LoggerFilter());
        if (builder.role == Role.CLIENT) {
            builder.processor.setSender(this);
            WaitForConnection connectionWaiter = new WaitForConnection(builder.processor);
            this.filterChainBuilder.add((Filter)new ClientLineHandler(connectionWaiter));
            this.connect(builder.host, builder.port, connectionWaiter);
        } else {
            this.filterChainBuilder.add((Filter)new AcceptorProcessorCreatorFilter(builder.acceptorProcessor));
            this.start(builder.latch);
        }
    }

    public void connect(String host, int port, WaitForConnection connectionWaiter) throws Exception {
        logger.debug("Starting outbound sender transport to " + host + ":" + port);
        this.transport = TCPNIOTransportBuilder.newInstance().build();
        this.transport.setProcessor((Processor)this.filterChainBuilder.build());
        this.transport.start();
        logger.debug(this.role + ": attempting connection to " + host + ":" + port);
        this.connection = (Connection)this.transport.connect(host, port).get();
        if (this.sslFilter.isAlwaysSSL()) {
            this.sslFilter.doHandshake(this.connection);
        }
        connectionWaiter.haveConnection();
        logger.debug(this.role + ": successfully connected ... " + this.connection);
    }

    public Connection<?> getConnection() {
        return this.connection;
    }

    @Override
    public void process(String string) {
        logger.debug(this.role + ": sending " + string + " on " + this.connection);
        this.connection.write((Object)string);
    }

    @Override
    public void enterTLSMode() {
        GrizzlyResponseHandler.moveToTLS(this.getConnection());
    }

    @Override
    public void processNoLineBreak(String msg) {
        throw new NotImplementedException();
    }

    @Override
    public void processStream(InputStream stream) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close().get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw WrappedException.wrap(e);
        }
    }

    public void start(CountDownLatch cdl) throws IOException {
        this.transport = TCPNIOTransportBuilder.newInstance().build();
        if (this.port <= 0) {
            ServerSocket ss = new ServerSocket();
            ss.bind(new InetSocketAddress("0.0.0.0", 0));
            this.port = ss.getLocalPort();
            ss.close();
        }
        logger.info("Starting transport for " + this.port);
        this.transport.setProcessor((Processor)this.filterChainBuilder.build());
        this.transport.bind("0.0.0.0", this.port);
        this.transport.start();
        if (cdl != null) {
            cdl.countDown();
        }
    }

    public void stop() {
        if (this.role == Role.CLIENT) {
            this.stopClient();
        } else {
            this.stopAcceptor();
        }
    }

    private void stopAcceptor() {
        logger.info("Stopping transport for " + this.port);
        try {
            this.transport.shutdown().get(1L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            logger.error("Error shutting down transport", (Throwable)ex);
        }
        logger.info("Stopped transport for " + this.port);
    }

    private void stopClient() {
        logger.debug("Closing connection");
        try {
            this.connection.close().get();
        }
        catch (Exception ex) {
            logger.error("Error closing connection ", (Throwable)ex);
        }
        logger.debug("Stopping outbound sender transport...");
        if (this.transport != null) {
            this.transport.shutdown();
        }
        logger.debug("Stopped oubound sender transport...");
    }

    public String uri() {
        return "http://localhost:" + this.port;
    }

    public class WaitForConnection
    implements ReplyLineProcessor {
        private final ReplyLineProcessor processor;
        private final List<String> queue = new ArrayList<String>();
        private boolean haveConnection;

        public WaitForConnection(ReplyLineProcessor processor) {
            this.processor = processor;
        }

        @Override
        public synchronized void process(String msg) {
            if (this.haveConnection) {
                this.processor.process(msg);
            } else {
                this.queue.add(msg);
            }
        }

        @Override
        public void setSender(ResponseHandler replier) {
            throw new NotImplementedException();
        }

        public synchronized void haveConnection() {
            while (this.queue.size() > 0) {
                this.processor.process(this.queue.remove(0));
            }
            this.haveConnection = true;
        }
    }
}

