/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.inabox.grizzly.actors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.GrizzlyException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.inabox.grizzly.AcceptorProcessor;
import org.zinutils.inabox.grizzly.actors.GrizzlyEndpoint;
import org.zinutils.inabox.grizzly.actors.Role;
import org.zinutils.inabox.grizzly.filters.ReplyLineProcessor;

public class GrizzlyBuilder {
    public static final Logger logger;
    final Role role;
    boolean alwaysSSL = false;
    SSLEngineConfigurator sslConfig = null;
    boolean addBreaks = true;
    String host = null;
    int port = -1;
    CountDownLatch latch = null;
    public ReplyLineProcessor processor;
    public AcceptorProcessor acceptorProcessor;

    public GrizzlyBuilder(Role r, String host, int port) {
        this.role = r;
        this.host = host;
        this.port = port;
    }

    public GrizzlyBuilder ssl(SSLEngineConfigurator sslConfig, boolean alwaysSSL) {
        this.sslConfig = sslConfig;
        this.alwaysSSL = alwaysSSL;
        return this;
    }

    public static SSLEngineConfigurator initializeSSL(String ksFile, String ksPassword) throws GrizzlyException {
        if (ksFile == null) {
            throw new GrizzlyException("No keystore specified");
        }
        if (ksPassword == null) {
            throw new GrizzlyException("No keystore password specified");
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream ksi = null;
            char[] ksp = ksPassword.toCharArray();
            ksi = new FileInputStream(ksFile);
            ks.load(ksi, ksp);
            ((InputStream)ksi).close();
            return GrizzlyBuilder.sslConfigurator(ks, ksp);
        }
        catch (KeyStoreException e) {
            throw new GrizzlyException("Cannot instantiate JKS keystore");
        }
        catch (FileNotFoundException e) {
            throw new GrizzlyException("there is no keystore file " + ksFile);
        }
        catch (IOException e) {
            throw new GrizzlyException("could not read keystore file " + ksFile);
        }
        catch (KeyManagementException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new GrizzlyException("error instantiating key from file " + ksFile + ": " + e.getMessage());
        }
    }

    public static SSLEngineConfigurator initializeSSLFromOpenSSL(File privkey, String cert) throws GrizzlyException {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException e) {
            throw new GrizzlyException("Cannot instantiate PKCS12 keystore");
        }
        try {
            FileInputStream kfis = new FileInputStream(privkey);
            ks.load(kfis, cert.toCharArray());
            return GrizzlyBuilder.sslConfigurator(ks, cert.toCharArray());
        }
        catch (FileNotFoundException e) {
            throw new GrizzlyException("there is no key file " + privkey);
        }
        catch (IOException e) {
            throw new GrizzlyException("could not read key file " + privkey);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new GrizzlyException("error instantiating key from file " + privkey + ": " + e.getMessage());
        }
    }

    public static SSLEngineConfigurator selfServingSSL() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] ksp = "".toCharArray();
        GrizzlyBuilder.createCertificate(ks, ksp, InetAddress.getLocalHost().getHostName());
        return GrizzlyBuilder.sslConfigurator(ks, ksp);
    }

    private static SSLEngineConfigurator sslConfigurator(KeyStore ks, char[] ksp) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, ksp);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), null, null);
        return new SSLEngineConfigurator(sslContext, false, false, false);
    }

    public static SSLEngineConfigurator initializeSSLAsAVeryTrustingClient() throws Exception {
        return GrizzlyBuilder.createSSLClient(GrizzlyBuilder.trustAllCerts());
    }

    public static void makeSSLDefaultToTrusting() throws Exception {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, GrizzlyBuilder.trustAllCerts(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                System.out.println("Verifying " + hostname);
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private static TrustManager[] trustAllCerts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                logger.debug("checking trusted server with " + certs.length + " certificate(s) and auth type " + authType);
            }
        }};
        return trustAllCerts;
    }

    public static SSLEngineConfigurator createDefaultSSLClient() throws Exception {
        return GrizzlyBuilder.createSSLClient(null);
    }

    public static SSLEngineConfigurator createSSLClient(TrustManager[] trustMgr) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustMgr, null);
        return new SSLEngineConfigurator(sslContext, false, false, false).setClientMode(true);
    }

    public static void createCertificate(KeyStore ks, char[] password, String cn) throws Exception {
        ks.load(null, null);
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        X509Certificate cert = GrizzlyBuilder.generateCertificate("CN=" + cn, keyPair, 10, "SHA1withRSA");
        ks.setKeyEntry("key", keyPair.getPrivate(), password, new Certificate[]{cert});
    }

    public static X509Certificate generateCertificate(String dn, KeyPair keyPair, int days, String algorithm) {
        try {
            X509Certificate cert = null;
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            v3CertGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            v3CertGen.setIssuerDN((X509Name)new X509Principal(dn));
            v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 86400000L));
            v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 86400000L * (long)days * 10L));
            v3CertGen.setSubjectDN((X509Name)new X509Principal(dn));
            v3CertGen.setPublicKey(keyPair.getPublic());
            v3CertGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
            cert = v3CertGen.generateX509Certificate(keyPair.getPrivate());
            return cert;
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public GrizzlyEndpoint build() throws Exception {
        return new GrizzlyEndpoint(this);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = LoggerFactory.getLogger((String)"inabox.Grizzly");
    }
}

