/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.http.HttpAnswer;
import org.zinutils.http.HttpClientAnswer;
import org.zinutils.http.HttpExecutor;

public class HttpClientExecutor
implements HttpExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"HttpCli");
    private static final AtomicReference<SSLContext> sslContext = new AtomicReference<Object>(null);
    private final CloseableHttpClient cli;

    public HttpClientExecutor() {
        String certdir = System.getProperty("org.ziniki.certificate.path");
        if (certdir == null) {
            this.cli = HttpClients.createDefault();
        } else {
            logger.info("loading certificate from " + certdir);
            this.loadCertificates(certdir);
            this.cli = HttpClients.custom().setSSLContext(sslContext.get()).build();
        }
    }

    @Override
    public HttpAnswer exec(HttpUriRequest exec) throws ClientProtocolException, IOException {
        return new HttpClientAnswer(this.cli.execute(exec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertificates(String certdir) {
        AtomicReference<SSLContext> atomicReference = sslContext;
        synchronized (atomicReference) {
            if (sslContext.get() == null) {
                String[] certs = certdir.split(File.pathSeparator);
                try {
                    SSLContext cxt = SSLContext.getInstance("TLS");
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    for (String s : certs) {
                        try (FileInputStream fis = new FileInputStream(s);){
                            X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                            ks.setCertificateEntry(new File(s).getName(), cert);
                        }
                        catch (FileNotFoundException ex) {
                            logger.warn("did not find certificate file " + s);
                        }
                        catch (IOException ex) {
                            logger.warn("IOException reading certificate file " + s + ": " + ex.getMessage());
                        }
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    cxt.init(null, tmf.getTrustManagers(), null);
                    sslContext.set(cxt);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error loading certificates: " + ex.getMessage());
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException("failed to create TLS context to connect to server: " + e);
                }
            }
        }
    }
}

