/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.ZinikiHttpException;
import org.zinutils.http.HttpAnswer;
import org.zinutils.utils.FileUtils;

public class HttpClientAnswer
implements HttpAnswer {
    private final CloseableHttpResponse response;

    public HttpClientAnswer(CloseableHttpResponse response) {
        this.response = response;
    }

    @Override
    public void assertSuccess() {
        if (this.response == null) {
            throw new CantHappenException("failed to get any response");
        }
        if (this.response.getStatusLine().getStatusCode() / 100 != 2) {
            throw new ZinikiHttpException("received error code " + this.response.getStatusLine());
        }
    }

    @Override
    public boolean isLoggedIn() {
        if (this.response == null) {
            throw new CantHappenException("failed to get any response");
        }
        int code = this.response.getStatusLine().getStatusCode();
        if (code / 100 == 2) {
            return true;
        }
        if (code == 401) {
            return false;
        }
        throw new ZinikiHttpException("received error code " + this.response.getStatusLine());
    }

    @Override
    public String getLoginUri() {
        Header hdr = this.response.getFirstHeader("Login-URI");
        if (hdr == null) {
            throw new CantHappenException("did not receive a Login URI");
        }
        return hdr.getValue();
    }

    @Override
    public String getDesktopUri() {
        Header hdr = this.response.getFirstHeader("Desktop-URI");
        if (hdr == null) {
            throw new CantHappenException("did not receive a Login URI");
        }
        return hdr.getValue();
    }

    @Override
    public String asUtf8() throws UnsupportedEncodingException, UnsupportedOperationException, IOException {
        return new String(FileUtils.readAllStream(this.response.getEntity().getContent()), "UTF-8");
    }

    @Override
    public Document asHTML(String baseuri) throws UnsupportedOperationException, IOException {
        return Jsoup.parse((InputStream)this.response.getEntity().getContent(), (String)"UTF-8", (String)baseuri);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.response.getEntity() != null) {
            this.response.getEntity().writeTo(out);
        }
    }
}

