/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.graphs;

import java.util.HashSet;
import java.util.Set;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.UtilException;
import org.zinutils.graphs.Link;
import org.zinutils.graphs.Node;

public class Tree<N> {
    private final Node<N> root;
    private final HashSet<Node<N>> nodes = new HashSet();
    private final HashSet<Link<N>> links = new HashSet();

    public Tree(N root) {
        this.root = new Node<N>(root);
        this.nodes.add(this.root);
    }

    public Node<N> getRoot() {
        return this.root;
    }

    public Node<N> find(N n) {
        for (Node<N> ret : this.nodes) {
            if (!ret.node.equals(n)) continue;
            return ret;
        }
        throw new UtilException("The value " + n + " was not in the tree");
    }

    public Node<N> addChild(Node<N> from, N to) {
        Node<N> nt = new Node<N>(to);
        this.nodes.add(nt);
        Link<N> link = new Link<N>(from, nt);
        this.links.add(link);
        from.addLinkFrom(link);
        nt.addLinkTo(link);
        return nt;
    }

    public Set<Node<N>> getChildren(Node<N> node) {
        HashSet<Node<N>> ret = new HashSet<Node<N>>();
        for (Link<N> l : node.linksFrom()) {
            ret.add(l.to);
        }
        return ret;
    }

    public Node<N> getParent(Node<N> node) {
        if (node == this.root) {
            return null;
        }
        return CollectionUtils.any(node.linksTo()).from;
    }

    public int size() {
        return this.nodes.size();
    }

    public Set<N> allNodes() {
        HashSet ret = new HashSet();
        for (Node<N> n : this.nodes) {
            ret.add(n.node);
        }
        return ret;
    }

    public String toString() {
        return this.root.toString() + this.nodes + this.links;
    }
}

