/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.graphs;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.graphs.Link;
import org.zinutils.graphs.Node;
import org.zinutils.graphs.NodeWalker;

public class ParallelTraverser<N> {
    public static final Logger logger = LoggerFactory.getLogger((String)"ZinUtils");
    private final ExecutorService exec;
    private final NodeWalker<N> walker;
    private final List<Throwable> errs;
    private final CountDownLatch cdl;
    private final Set<Node<N>> done;
    private final Set<Node<N>> taken;
    private final Set<Node<N>> submitted;

    public ParallelTraverser(ExecutorService exec, NodeWalker<N> walker, List<Throwable> errs, CountDownLatch cdl) {
        this.exec = exec;
        this.walker = walker;
        this.errs = errs;
        this.cdl = cdl;
        this.done = Collections.synchronizedSet(new HashSet());
        this.taken = Collections.synchronizedSet(new HashSet());
        this.submitted = Collections.synchronizedSet(new HashSet());
    }

    public void ready(Node<N> n) {
        this.submitted.add(n);
        logger.info("Submitting " + n.node + " with " + n.linksFrom().size() + " down links and exec " + this.exec.isShutdown() + " and cdl " + this.cdl.getCount());
        this.exec.execute(() -> {
            try {
                Set<Node<N>> set = this.taken;
                synchronized (set) {
                    logger.info("Executing " + n.node + " taken = " + this.taken.contains(n));
                    if (this.taken.contains(n)) {
                        return;
                    }
                    this.taken.add(n);
                }
                this.walker.present(n);
                this.done.add(n);
                this.pushReady(n);
                this.cdl.countDown();
                logger.info("After " + n.node + " cdl = " + this.cdl.getCount());
            }
            catch (Throwable t) {
                logger.error("Error traversing " + n.node, t);
                this.errs.add(t);
                while (this.cdl.getCount() > 0L) {
                    this.cdl.countDown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushReady(Node<N> n) {
        ParallelTraverser parallelTraverser = this;
        synchronized (parallelTraverser) {
            block3: for (Link<N> up : n.linksTo()) {
                Node candidate = up.from;
                logger.debug("Considering " + candidate.node);
                if (this.done.contains(candidate)) continue;
                for (Link down : candidate.linksFrom()) {
                    if (this.done.contains(down.to)) continue;
                    logger.debug("Rejecting " + candidate.node + " because " + down.to.node + " is not ready");
                    continue block3;
                }
                logger.debug("Submitting " + candidate.node);
                this.ready(candidate);
            }
        }
    }

    public void dump() {
        for (Node<N> n : this.submitted) {
            System.out.println(n.node + " => " + this.taken.contains(n) + " " + this.done.contains(n));
            if (this.done.contains(n)) continue;
            for (Link<N> down : n.linksFrom()) {
                System.out.println("  needs " + down.to + " " + this.taken.contains(down.to) + " " + this.done.contains(down.to));
            }
        }
    }
}

