/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.graphs;

import java.util.HashSet;
import java.util.Set;
import org.zinutils.exceptions.UtilException;
import org.zinutils.graphs.Link;

public class Node<N> {
    N node;
    private Set<Link<N>> linksTo = new HashSet<Link<N>>();
    private Set<Link<N>> linksFrom = new HashSet<Link<N>>();

    public Node(N node) {
        if (node == null) {
            throw new UtilException("Cannot add null node");
        }
        this.node = node;
    }

    public void addLinkTo(Link<N> link) {
        this.linksTo.add(link);
    }

    public void addLinkFrom(Link<N> link) {
        this.linksFrom.add(link);
    }

    public Set<N> span() {
        HashSet<Node<N>> nodes = new HashSet<Node<N>>();
        this.span(nodes);
        HashSet<N> ret = new HashSet<N>();
        for (Node node : nodes) {
            ret.add(node.node);
        }
        return ret;
    }

    private void span(Set<Node<N>> nodes) {
        nodes.add(this);
        for (Link<N> l : this.linksFrom) {
            if (nodes.contains(l.to)) continue;
            l.to.span(nodes);
        }
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Node && ((Node)obj).node.equals(this.node);
    }

    public Set<Link<N>> linksTo() {
        return this.linksTo;
    }

    public String toString() {
        return this.node.toString();
    }

    public Set<Link<N>> linksFrom() {
        return this.linksFrom;
    }

    public N getEntry() {
        return this.node;
    }

    void setEntry(N br) {
        this.node = br;
    }
}

