/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.graphs;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.zinutils.exceptions.UtilException;
import org.zinutils.graphs.Link;
import org.zinutils.graphs.Node;

public class DirectedCyclicGraph<N> {
    protected final HashSet<Node<N>> nodes = new HashSet();
    protected final HashSet<Link<N>> links = new HashSet();

    public void newNode(N node) {
        if (this.hasNode(node)) {
            throw new UtilException("Cannot add the same node " + node + " twice");
        }
        Node<N> n = new Node<N>(node);
        this.nodes.add(n);
    }

    public boolean hasNode(N node) {
        for (Node<N> n : this.nodes) {
            if (!n.node.equals(node)) continue;
            return true;
        }
        return false;
    }

    public void ensure(N node) {
        if (this.hasNode(node)) {
            return;
        }
        this.newNode(node);
    }

    public Set<N> nodes() {
        HashSet<N> ret = new HashSet<N>();
        for (Node<N> n : this.nodes) {
            ret.add(n.getEntry());
        }
        return ret;
    }

    public Set<Link<N>> links() {
        return this.links;
    }

    public void link(N from, N to) {
        Node<N> f = this.find(from);
        Node<N> t = this.find(to);
        this.addLink(new Link<N>(f, t));
    }

    public boolean hasLink(N from, N to) {
        return this.hasLinkInternal(from, to) == null;
    }

    private Link<N> hasLinkInternal(N from, N to) {
        Node<N> t;
        Node<N> f = this.find(from);
        Link<N> l = new Link<N>(f, t = this.find(to));
        if (this.links.contains(l)) {
            return null;
        }
        return l;
    }

    public void ensureLink(N from, N to) {
        Link<N> l = this.hasLinkInternal(from, to);
        if (l != null) {
            this.addLink(l);
        }
    }

    protected void addLink(Link<N> link) {
        this.links.add(link);
        link.from.addLinkFrom(link);
        link.to.addLinkTo(link);
    }

    public Node<N> find(N n) {
        for (Node<N> ret : this.nodes) {
            if (!ret.node.equals(n)) continue;
            return ret;
        }
        throw new UtilException("The node " + n + " was not in the graph");
    }

    public Set<Node<N>> findAll(Predicate<N> pred) {
        HashSet<Node<N>> ret = new HashSet<Node<N>>();
        for (Node<N> n : this.nodes) {
            if (!pred.test(n.node)) continue;
            ret.add(n);
        }
        return ret;
    }

    public Set<N> spanOf(N n) {
        return this.find(n).span();
    }

    public Iterable<N> children(N node) {
        HashSet ret = new HashSet();
        Node<N> root = this.find(node);
        for (Link<N> l : root.linksFrom()) {
            ret.add(l.to.node);
        }
        return ret;
    }

    public Iterable<N> allChildren(N node) {
        int cnt;
        HashSet<Object> ret = new HashSet<Object>();
        ret.add(node);
        do {
            cnt = ret.size();
            HashSet n2 = new HashSet();
            for (Object e : ret) {
                Node root = this.find(e);
                for (Link l : root.linksFrom()) {
                    n2.add(l.to.node);
                }
            }
            ret.addAll(n2);
        } while (ret.size() > cnt);
        ret.remove(node);
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        TreeMap<String, Node<N>> ordered = new TreeMap<String, Node<N>>();
        for (Node<N> node : this.nodes) {
            ordered.put(node.toString(), node);
        }
        for (Node<Object> node : ordered.values()) {
            ret.append("Node " + node + " depends on:\n");
            TreeSet<CallSite> orderedLinks = new TreeSet<CallSite>();
            for (Link<Object> link : node.linksFrom()) {
                orderedLinks.add((CallSite)((Object)("  " + link.to + "\n")));
            }
            for (String string : orderedLinks) {
                ret.append(string);
            }
        }
        return ret.toString();
    }

    public void rename(Node<N> node, N entry) {
        Node<N> curr = this.find(entry);
        if (curr != null && curr != node) {
            throw new UtilException("Cannot create duplicate node name " + entry);
        }
        node.setEntry(entry);
    }

    public void clear() {
        this.nodes.clear();
        this.links.clear();
    }
}

