/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.CycleDetectedException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.graphs.DirectedCyclicGraph;
import org.zinutils.graphs.Link;
import org.zinutils.graphs.Node;
import org.zinutils.graphs.NodeWalker;
import org.zinutils.graphs.ParallelTraverser;

public class DirectedAcyclicGraph<N>
extends DirectedCyclicGraph<N> {
    public static final Logger logger = LoggerFactory.getLogger((String)"ZinUtils");
    static String patienceChild = System.getProperty("org.flasck.patience.child");
    boolean wantTimeout = patienceChild == null || !patienceChild.equals("true");
    private Comparator<Node<N>> nodeSpanSize = new Comparator<Node<N>>(){

        @Override
        public int compare(Node<N> lhs, Node<N> rhs) {
            if (lhs.span().size() > rhs.span().size()) {
                return -1;
            }
            if (lhs.span().size() == rhs.span().size()) {
                return 0;
            }
            return 1;
        }
    };
    private final Comparator<N> spanSize = new Comparator<N>(){

        @Override
        public int compare(N arg0, N arg1) {
            Node lhs = DirectedAcyclicGraph.this.find(arg0);
            Node rhs = DirectedAcyclicGraph.this.find(arg1);
            return DirectedAcyclicGraph.this.nodeSpanSize.compare(lhs, rhs);
        }
    };

    @Override
    protected void addLink(Link<N> link) {
        if (link.to.span().contains(link.from.node)) {
            throw new CycleDetectedException("Adding link from " + link.from.node + " to " + link.to.node + " creates a cycle: " + link.to.span());
        }
        super.addLink(link);
    }

    public List<N> roots() {
        ArrayList ret = new ArrayList();
        for (Node n : this.nodes) {
            if (n.linksTo().size() != 0) continue;
            ret.add(n.node);
        }
        Collections.sort(ret, this.spanSize);
        return ret;
    }

    public void assertSpanning() {
        List<N> roots = this.roots();
        if (roots.size() != 1) {
            throw new UtilException("The graph had more than one root");
        }
    }

    public void postOrderTraverse(NodeWalker<N> nodeWalker) {
        HashSet<Node<N>> done = new HashSet<Node<N>>();
        ArrayList<Node<N>> todo = new ArrayList<Node<N>>();
        for (N n : this.roots()) {
            todo.add(this.find(n));
        }
        this.postOrder(nodeWalker, done, todo, this.nodeSpanSize);
    }

    public void postOrderFrom(NodeWalker<N> nodeWalker, N from) {
        this.postOrderFromWithOrder(nodeWalker, from, null);
    }

    public void postOrderFromWithOrder(NodeWalker<N> nodeWalker, N from, Comparator<N> order) {
        HashSet<Node<N>> done = new HashSet<Node<N>>();
        ArrayList<Node<N>> todo = new ArrayList<Node<N>>();
        todo.add(this.find(from));
        this.postOrder(nodeWalker, done, todo, new AndMoreComparator(order));
    }

    private void postOrder(NodeWalker<N> walker, Set<Node<N>> done, List<Node<N>> todo, Comparator<Node<N>> order) {
        for (Node<N> n : todo) {
            if (done.contains(n)) continue;
            done.add(n);
            if (n.linksFrom().size() > 0) {
                HashSet foo = new HashSet();
                for (Link<N> l : n.linksFrom()) {
                    foo.add(l.to);
                }
                this.postOrder(walker, done, CollectionUtils.setToList(foo, order), order);
            }
            walker.present(n);
        }
    }

    public void leafFirstParallelTraversal(ExecutorService exec, NodeWalker<N> walker, int mstimeout) {
        Set<Node<N>> next = this.findLeafLayer();
        List<Throwable> errs = Collections.synchronizedList(new ArrayList());
        CountDownLatch cdl = new CountDownLatch(this.nodes.size());
        ParallelTraverser<N> pt = new ParallelTraverser<N>(exec, walker, errs, cdl);
        for (Node<N> n : next) {
            pt.ready(n);
        }
        try {
            if (this.wantTimeout) {
                cdl.await(mstimeout, TimeUnit.MILLISECONDS);
            } else {
                cdl.await();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!errs.isEmpty()) {
            throw WrappedException.wrap(errs.get(0));
        }
        if (cdl.getCount() != 0L) {
            pt.dump();
            throw new HaventConsideredThisException("time out encountered waiting for executor to complete");
        }
    }

    private Set<Node<N>> findLeafLayer() {
        HashSet<Node<N>> ret = new HashSet<Node<N>>();
        for (Node n : this.nodes) {
            if (!n.linksFrom().isEmpty()) continue;
            ret.add(n);
        }
        return ret;
    }

    public class AndMoreComparator
    implements Comparator<Node<N>> {
        private final Comparator<N> order;

        public AndMoreComparator(Comparator<N> order) {
            this.order = order;
        }

        @Override
        public int compare(Node<N> o1, Node<N> o2) {
            int ret = DirectedAcyclicGraph.this.nodeSpanSize.compare(o1, o2);
            if (ret != 0) {
                return ret;
            }
            return this.order.compare(o1.node, o2.node);
        }
    }
}

