/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.exceptions;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;

public class WrappedException
extends RuntimeException {
    public WrappedException(Throwable ex) {
        super("Wrapped Exception", ex);
    }

    public Exception unwrap() {
        Throwable ex2 = this.getCause();
        if (ex2 instanceof Exception) {
            return WrappedException.unwrapAny((Exception)ex2);
        }
        return this;
    }

    public static Throwable unwrapThrowable(Throwable ex) {
        Throwable ex2;
        if (ex instanceof WrappedException) {
            ex2 = ex.getCause();
        } else if (ex instanceof InvocationTargetException) {
            ex2 = ((InvocationTargetException)ex).getTargetException();
        } else if (ex instanceof ExecutionException) {
            ex2 = ((ExecutionException)ex).getCause();
        } else {
            return ex;
        }
        if (ex2 != ex && ex2 != null) {
            return WrappedException.unwrapThrowable(ex2);
        }
        return ex;
    }

    public static Exception unwrapAny(Exception ex) {
        Throwable ex2;
        if ((ex instanceof WrappedException || ex instanceof InvocationTargetException || ex instanceof ExecutionException) && (ex2 = ex.getCause()) instanceof Exception && ex2 != ex) {
            return WrappedException.unwrapAny((Exception)ex2);
        }
        return ex;
    }

    public static RuntimeException wrap(Throwable ex) {
        while (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new WrappedException(ex);
    }
}

