/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.exceptions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.zinutils.exceptions.WrappedException;

public class UtilException
extends RuntimeException {
    public UtilException(String string) {
        super(string);
    }

    public UtilException(String string, Throwable ex) {
        super(string, ex);
    }

    public static RuntimeException wrap(Throwable ex) {
        return WrappedException.wrap(ex);
    }

    public static Throwable unwrap(Throwable ex) {
        if (ex instanceof WrappedException) {
            return ((WrappedException)ex).unwrap();
        }
        if (ex instanceof InvocationTargetException || ex instanceof ExecutionException) {
            return UtilException.unwrap(ex.getCause());
        }
        return ex;
    }

    public static Exception reconstitute(String exClass, String msg) {
        if (exClass == null) {
            return new UtilException("Exception occurred, but no details provided");
        }
        try {
            Class<?> forName = Class.forName(exClass);
            try {
                Constructor<?> ctor = forName.getDeclaredConstructor(String.class);
                ctor.setAccessible(true);
                if (ctor != null) {
                    return (Exception)ctor.newInstance(msg);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return (Exception)forName.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            return new UtilException("Exception of unrecognized class " + exClass + " thrown by server", ex);
        }
    }
}

