/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.zinutils.exceptions.UtilException;

public class SetMap<K, V>
implements Iterable<K> {
    private final Map<K, Set<V>> map;
    private final Comparator<V> valueComp;
    private final Comparator<K> keyComp;

    public SetMap() {
        this(null, null);
    }

    public SetMap(Comparator<K> f2comp) {
        this(f2comp, null);
    }

    public SetMap(Comparator<K> keyComp, Comparator<V> valueComp) {
        this.keyComp = keyComp;
        this.map = keyComp == null ? new HashMap<K, Set<V>>() : new TreeMap<K, Set<V>>(keyComp);
        this.valueComp = valueComp;
    }

    public void clear() {
        this.map.clear();
    }

    public void add(K k, V v) {
        this.ensure(k);
        this.map.get(k).add(v);
    }

    public void ensure(K k) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, this.valueComp == null ? new HashSet() : new TreeSet<V>(this.valueComp));
        }
    }

    public boolean remove(K k, V v) {
        if (!this.map.containsKey(k)) {
            return false;
        }
        return this.map.get(k).remove(v);
    }

    public Set<V> extractKey(K key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        return this.map.remove(key);
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    public Collection<V> values() {
        HashSet<V> accum = new HashSet<V>();
        for (Set<V> v : this.map.values()) {
            accum.addAll(v);
        }
        return accum;
    }

    public Set<V> get(K k) {
        if (!this.map.containsKey(k)) {
            throw new UtilException("There is no key '" + k + "' in " + this);
        }
        return this.map.get(k);
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public String toString() {
        return this.map.toString();
    }

    public void addAll(K k, Iterable<V> vals) {
        for (V v : vals) {
            this.add(k, v);
        }
    }

    public void addAll(SetMap<K, V> setMap) {
        for (K k : setMap.keySet()) {
            this.addAll(k, setMap.get(k));
        }
    }

    public void removeAll(K k) {
        this.map.remove(k);
    }

    public int totalSize() {
        int ret = 0;
        for (Set<V> x : this.map.values()) {
            ret += x.size();
        }
        return ret;
    }

    public int size(K k) {
        if (!this.map.containsKey(k)) {
            return 0;
        }
        return this.map.get(k).size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public SetMap<K, V> duplicate() {
        SetMap<K, V> ret = new SetMap<K, V>(this.keyComp, this.valueComp);
        for (K k : this.keySet()) {
            ret.ensure(k);
            for (V v : this.get(k)) {
                ret.add(k, v);
            }
        }
        return ret;
    }
}

