/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zinutils.exceptions.UtilException;

public class MapMap<F1, F2, T> {
    private Map<F1, Map<F2, T>> map = new HashMap<F1, Map<F2, T>>();

    public void add(F1 f1, F2 f2, T v) {
        if (!this.map.containsKey(f1)) {
            this.map.put(f1, new HashMap());
        }
        this.map.get(f1).put(f2, v);
    }

    public void addAll(MapMap<F1, F2, T> eventHandlers) {
        for (F1 k1 : eventHandlers.key1Set()) {
            if (!this.map.containsKey(k1)) {
                this.map.put(k1, new HashMap());
            }
            Map<F2, T> m1 = this.map.get(k1);
            m1.putAll(eventHandlers.map.get(k1));
        }
    }

    public T get(F1 f1, F2 f2) {
        if (!this.map.containsKey(f1)) {
            throw new UtilException("There is no key '" + f1 + "' in " + this);
        }
        return this.map.get(f1).get(f2);
    }

    public boolean contains(F1 f1) {
        return this.map.containsKey(f1);
    }

    public boolean contains(F1 f1, F2 f2) {
        return this.map.containsKey(f1) && this.map.get(f1).containsKey(f2);
    }

    public void remove(F1 f1, F2 f2) {
        Map<F2, T> listMap = this.map.get(f1);
        listMap.remove(f2);
    }

    public String toString() {
        return this.map.toString();
    }

    public Set<F1> key1Set() {
        return this.map.keySet();
    }

    public Set<F2> key2Set(F1 key) {
        if (!this.map.containsKey(key)) {
            throw new UtilException("There is no entry for " + key);
        }
        return this.map.get(key).keySet();
    }

    public Collection<T> values() {
        HashSet<T> ret = new HashSet<T>();
        for (Map<F2, T> lm : this.map.values()) {
            ret.addAll(lm.values());
        }
        return ret;
    }

    public void clear() {
        this.map.clear();
    }
}

