/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.zinutils.exceptions.UtilException;

public class ListMap<K, V>
implements Iterable<K> {
    private final Map<K, List<V>> map;

    public ListMap() {
        this.map = new LinkedHashMap<K, List<V>>();
    }

    public ListMap(Comparator<K> order) {
        this.map = new TreeMap<K, List<V>>(order);
    }

    public void add(K k, V v) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, new ArrayList());
        }
        this.map.get(k).add(v);
    }

    public void add(K k, int pos, V v) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, new ArrayList());
        }
        this.map.get(k).add(pos, v);
    }

    public void addAll(ListMap<K, V> other) {
        for (K k : other.keySet()) {
            if (!this.map.containsKey(k)) {
                this.map.put(k, new ArrayList());
            }
            this.map.get(k).addAll(other.get(k));
        }
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    public List<V> get(K k) {
        if (!this.map.containsKey(k)) {
            throw new UtilException("There is no key '" + k + "' in " + this);
        }
        return this.map.get(k);
    }

    public int totalSize() {
        int ret = 0;
        for (List<V> l : this.map.values()) {
            ret += l.size();
        }
        return ret;
    }

    public int size(K k) {
        if (!this.map.containsKey(k)) {
            return 0;
        }
        return this.map.get(k).size();
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public String toString() {
        return this.map.toString();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        HashSet<V> ret = new HashSet<V>();
        for (List<V> vs : this.map.values()) {
            ret.addAll(vs);
        }
        return ret;
    }

    public List<V> removeAll(K key) {
        return this.map.remove(key);
    }

    public void remove(K k, V v) {
        if (!this.map.containsKey(k)) {
            return;
        }
        List<V> list = this.map.get(k);
        list.remove(v);
        if (list.isEmpty()) {
            this.map.remove(k);
        }
    }

    public V removeFirst(K key) {
        if (!this.map.containsKey(key)) {
            throw new UtilException("There is no key " + key);
        }
        List<V> list = this.map.get(key);
        V ret = list.remove(0);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return ret;
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public void extract(Collection<V> ret, K k, int offset, int count) {
        if (!this.map.containsKey(k)) {
            return;
        }
        List<V> contents = this.map.get(k);
        for (int i = offset; i < count && contents.size() > i; ++i) {
            ret.add(contents.get(i));
        }
    }

    public void take(Collection<V> ret, K k, int count) {
        if (!this.map.containsKey(k)) {
            return;
        }
        List<V> contents = this.map.get(k);
        for (int i = 0; i < count && contents.size() > 0; ++i) {
            ret.add(contents.remove(0));
        }
    }

    public void ensure(K k) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, new ArrayList());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }
}

