/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zinutils.exceptions.UtilException;

public class CollectionUtils {
    public static <T> List<T> setToList(Set<T> in, Comparator<T> ordering) {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(in);
        Collections.sort(ret, ordering);
        return ret;
    }

    public static <T> T any(Iterable<T> coll) {
        Iterator<T> it = coll.iterator();
        if (!it.hasNext()) {
            throw new UtilException("Any requires at least one element to function");
        }
        return it.next();
    }

    public static <T> T nth(Iterable<T> coll, int which) {
        Iterator<T> it = coll.iterator();
        T ret = null;
        while (which-- >= 0) {
            ret = it.next();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        HashSet<T> ret = new HashSet<T>();
        for (T x : items) {
            ret.add(x);
        }
        return ret;
    }

    public static <T> ArrayList<T> array(Iterator<T> it) {
        ArrayList<T> ret = new ArrayList<T>();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public static <T> Map<String, T> map(Object ... args) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int i = 0;
        while (i + 1 < args.length) {
            ret.put((String)args[i], args[i + 1]);
            i += 2;
        }
        return ret;
    }

    public static <T> Iterable<T> iterableOf(final Iterator<T> keys) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return keys;
            }
        };
    }
}

