/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.cgharness;

import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.GenericAnnotator;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.cgharness.CGHClassLoader;
import org.zinutils.cgharness.TestMethodContentProvider;

public class CGHarnessRunnerHelper {
    public static ByteCodeCreator emptyTestClass(ByteCodeEnvironment bce, String name) {
        ByteCodeCreator bcc = new ByteCodeCreator(bce, name);
        bcc.superclass(Object.class.getName());
        GenericAnnotator ctor = GenericAnnotator.newConstructor(bcc, false);
        MethodDefiner done = ctor.done();
        done.callSuper("void", "java.lang.Object", "<init>", new IExpr[0]).flush();
        done.returnVoid().flush();
        return bcc;
    }

    public static void addMethod(ByteCodeCreator bcc, String name, boolean ignoreTest, TestMethodContentProvider provider) {
        GenericAnnotator runTest = GenericAnnotator.newMethod(bcc, false, name);
        runTest.returns("void");
        runTest.addRTVAnnotation("org.junit.Test");
        if (ignoreTest) {
            runTest.addRTVAnnotation("org.junit.Ignore");
        }
        MethodDefiner done = runTest.done();
        provider.defineMethod(done);
        done.returnVoid().flush();
    }

    public static Class<?> generate(CGHClassLoader cl, ByteCodeCreator bcc) {
        byte[] bs = bcc.generate();
        Class<?> clz = cl.defineClass(bcc.getCreatedName(), bs);
        return clz;
    }
}

