/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode.mock;

import java.util.List;

public class ShowDiff {
    private final List<String> lhs;
    private final List<String> rhs;
    private int l = 0;
    private int r = 0;
    private final int wid = 60;

    public ShowDiff(List<String> lhs, List<String> rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public void process() {
        while (this.l < this.lhs.size() || this.r < this.rhs.size()) {
            String rs;
            if (this.l >= this.lhs.size()) {
                this.show("", " > ", this.rhs.get(this.r++));
                continue;
            }
            if (this.r >= this.rhs.size()) {
                this.show(this.lhs.get(this.l++), " < ", "");
                continue;
            }
            String ls = this.lhs.get(this.l);
            if (ls.equals(rs = this.rhs.get(this.r))) {
                this.show(ls, "   ", rs);
                ++this.l;
                ++this.r;
                continue;
            }
            this.recalibrate();
        }
    }

    private void recalibrate() {
        int i = 1;
        while (this.l + i < this.lhs.size() && this.r + i < this.rhs.size()) {
            for (int j = 0; j <= i && this.l + j < this.lhs.size() && this.r + j < this.rhs.size(); ++j) {
                if (this.lhs.get(this.l + j).equals(this.rhs.get(this.r + i))) {
                    for (int k = 0; k < i; ++k) {
                        if (k < j) {
                            this.show(this.lhs.get(this.l + k), " | ", this.rhs.get(this.r + k));
                            continue;
                        }
                        this.show("", " > ", this.rhs.get(this.r + k));
                    }
                    this.r += i;
                    this.l += j;
                    return;
                }
                if (!this.lhs.get(this.l + i).equals(this.rhs.get(this.r + j))) continue;
                for (int k = 0; k < i; ++k) {
                    if (k < j) {
                        this.show(this.lhs.get(this.l + k), " | ", this.rhs.get(this.r + k));
                        continue;
                    }
                    this.show(this.lhs.get(this.l + k), " < ", "");
                }
                this.l += i;
                this.r += j;
                return;
            }
            ++i;
        }
        while (this.l < this.lhs.size()) {
            if (this.r < this.rhs.size()) {
                this.show(this.lhs.get(this.l++), " | ", this.rhs.get(this.r++));
                continue;
            }
            this.show(this.lhs.get(this.l++), " < ", "");
        }
        while (this.r < this.rhs.size()) {
            this.show("", " > ", this.rhs.get(this.r++));
        }
    }

    private void show(String ls, String sep, String rs) {
        System.out.println(this.format(ls, sep, rs));
    }

    private String format(String left, String sep, String right) {
        StringBuilder ret = new StringBuilder();
        this.append(ret, left);
        ret.append(sep);
        this.append(ret, right);
        return ret.toString();
    }

    private void append(StringBuilder ret, String s) {
        if (s.length() > 60) {
            ret.append(s.substring(0, 60));
            return;
        }
        ret.append(s);
        for (int i = s.length(); i < 60; ++i) {
            ret.append(" ");
        }
    }
}

