/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zinutils.bytecode.Annotation;
import org.zinutils.bytecode.BoolConstExpr;
import org.zinutils.bytecode.ByteCodeSink;
import org.zinutils.bytecode.DoubleConstExpr;
import org.zinutils.bytecode.Expr;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.bytecode.JavaType;
import org.zinutils.bytecode.Marker;
import org.zinutils.bytecode.MethodDefiner;
import org.zinutils.bytecode.PCExpr;
import org.zinutils.bytecode.Remarker;
import org.zinutils.bytecode.StackMapFrame;
import org.zinutils.bytecode.TryCatch;
import org.zinutils.bytecode.Var;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.bytecode.mock.StreamIExpr;
import org.zinutils.exceptions.NotImplementedException;

public class MethodStreamer
implements MethodDefiner {
    private final String clzName;
    private final boolean isStatic;
    private final String returnType;
    private final String name;
    private final List<String> contents = new ArrayList<String>();
    private int nextLocal = 1;
    private int iv = 0;

    public MethodStreamer(String clz, boolean isStatic, String returnType, String name) {
        this.clzName = clz;
        this.isStatic = isStatic;
        this.returnType = returnType;
        this.name = name;
    }

    @Override
    public int nextLocal() {
        int ret = this.nextLocal++;
        this.contents.add("{nextLocal " + ret + "}");
        return ret;
    }

    @Override
    public IExpr callSuper(String returns, String parentClzName, String methodName, IExpr ... args) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = super{" + parentClzName + "}." + methodName + Arrays.asList(args) + " -> " + returns);
        return ret;
    }

    @Override
    public IExpr returnVoid() {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = returnVoid");
        return ret;
    }

    @Override
    public Var.AVar myThis() {
        Var.AVar ret = new Var.AVar((MethodDefiner)this, this.clzName, "this");
        this.contents.add(ret + " = myThis");
        return ret;
    }

    @Override
    public Var argument(String type, String aname) {
        Var.AVar ret = new Var.AVar((MethodDefiner)this, type, aname);
        this.contents.add(ret + " = argument");
        return ret;
    }

    @Override
    public Var avar(String clz, String name) {
        Var.AVar ret = new Var.AVar((MethodDefiner)this, clz, name);
        this.contents.add(ret + " = avar " + clz + " " + name);
        return ret;
    }

    @Override
    public IExpr callInterface(String returns, IExpr obj, String methodName, IExpr ... args) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = callInterface " + obj + "." + methodName + " " + Arrays.asList(args) + " -> " + returns);
        return ret;
    }

    @Override
    public IExpr callVirtual(String returns, IExpr obj, String methodName, IExpr ... args) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = callVirtual " + obj + "." + methodName + " " + Arrays.asList(args) + " -> " + returns);
        return ret;
    }

    @Override
    public IExpr callStatic(String inClz, String returns, String methodName, IExpr ... args) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = callStatic " + inClz + "." + methodName + " " + Arrays.asList(args) + " -> " + returns);
        return ret;
    }

    @Override
    public IExpr assign(Var assignTo, IExpr expr) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = assign " + assignTo + " <- " + expr);
        return ret;
    }

    @Override
    public IExpr assign(IExpr field, IExpr expr) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = assign " + field + " <- " + expr);
        return ret;
    }

    @Override
    public IExpr stringConst(String str) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = sconst '" + str + "'");
        return ret;
    }

    @Override
    public IExpr intConst(int i) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = iconst " + i);
        return ret;
    }

    @Override
    public IExpr classConst(String cls) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = cconst " + cls + ".class");
        return ret;
    }

    @Override
    public IExpr as(IExpr expr, String newType) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = as " + newType + "(" + expr + ")");
        return ret;
    }

    @Override
    public IExpr voidExpr(IExpr ignoredResult) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = void " + ignoredResult);
        return ret;
    }

    @Override
    public IExpr returnObject(IExpr doCall) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = returnObject " + doCall);
        return ret;
    }

    @Override
    public IExpr makeNew(String ofClz, IExpr ... args) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = makeNew " + ofClz + " " + Arrays.asList(args));
        return ret;
    }

    @Override
    public IExpr getField(IExpr on, String name) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = getfield " + on + "." + name);
        return ret;
    }

    @Override
    public IExpr getField(String name) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = getfield this." + name);
        return ret;
    }

    @Override
    public IExpr arrayOf(String clz, IExpr ... as) {
        ArrayList<IExpr> al = new ArrayList<IExpr>();
        for (IExpr a : as) {
            al.add(a);
        }
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = arrayOf " + clz + al);
        return ret;
    }

    @Override
    public IExpr arrayOf(String clz, List<IExpr> al) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = arrayOf " + clz + al);
        return ret;
    }

    @Override
    public IExpr arrayElt(IExpr arr, IExpr elt) {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = arrayElt " + arr + "[" + elt + "]");
        return ret;
    }

    @Override
    public IExpr aNull() {
        StreamIExpr ret = this.makeIExpr();
        this.contents.add(ret + " = null");
        return ret;
    }

    @Override
    public ByteCodeSink getBCC() {
        throw new NotImplementedException();
    }

    @Override
    public String getName() {
        throw new NotImplementedException();
    }

    @Override
    public void throwsException(String exception) {
        throw new NotImplementedException();
    }

    @Override
    public Var getArgument(int i) {
        throw new NotImplementedException();
    }

    @Override
    public Var varOfType(String type, String aname) {
        throw new NotImplementedException();
    }

    @Override
    public Var saveAslocal(String clz, String name) {
        throw new NotImplementedException();
    }

    @Override
    public Expr arrayItem(String returnType, Var array, int idx) {
        throw new NotImplementedException();
    }

    @Override
    public Var avar(JavaType clz, String name) {
        throw new NotImplementedException();
    }

    @Override
    public Var ivar(String clz, String name) {
        throw new NotImplementedException();
    }

    @Override
    public Var lvar(String name) {
        throw new NotImplementedException();
    }

    @Override
    public Var dvar(String name) {
        throw new NotImplementedException();
    }

    @Override
    public int argCount() {
        throw new NotImplementedException();
    }

    @Override
    public Expr staticField(String clz, String type, String named) {
        throw new NotImplementedException();
    }

    @Override
    public BoolConstExpr boolConst(boolean b) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr block(IExpr ... exprs) {
        throw new NotImplementedException();
    }

    @Override
    public Expr callStatic(String inClz, JavaType returns, String methodName, IExpr ... args) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr castTo(IExpr expr, String ofType) {
        throw new NotImplementedException();
    }

    @Override
    public Expr concat(Object ... args) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr ifBoolean(IExpr expr, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr ifNotBoolean(IExpr expr, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr ifEquals(IExpr left, IExpr right, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public Expr ifNotNull(IExpr test, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public Expr ifNull(IExpr test, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr ifOp(int opcode, IExpr lhs, IExpr rhs, IExpr then, IExpr orelse) {
        throw new NotImplementedException();
    }

    @Override
    public Expr instanceOf(IExpr expr, String referencecontent) {
        throw new NotImplementedException();
    }

    @Override
    public DoubleConstExpr doubleConst(double d) {
        throw new NotImplementedException();
    }

    @Override
    public Expr isNull(Expr test, Expr yes, Expr no) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr makeNewVoid(String ofClz, IExpr ... args) {
        throw new NotImplementedException();
    }

    @Override
    public Expr returnTyped(Expr e) {
        throw new NotImplementedException();
    }

    @Override
    public Expr returnBool(IExpr i) {
        throw new NotImplementedException();
    }

    @Override
    public Expr returnInt(IExpr i) {
        throw new NotImplementedException();
    }

    @Override
    public Expr throwException(String clz, Expr ... args) {
        throw new NotImplementedException();
    }

    @Override
    public TryCatch tryCatch(Expr inBlock, String exType, Expr andThen) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr trueConst() {
        throw new NotImplementedException();
    }

    @Override
    public IExpr falseConst() {
        throw new NotImplementedException();
    }

    @Override
    public void lenientMode(boolean mode) {
        throw new NotImplementedException();
    }

    @Override
    public IExpr box(IExpr expr) {
        throw new NotImplementedException();
    }

    @Override
    public Expr unbox(Expr expr, boolean protectFromNulls) {
        throw new NotImplementedException();
    }

    @Override
    public void setAccess(JavaInfo.Access a) {
        throw new NotImplementedException();
    }

    @Override
    public void makeFinal() {
        throw new NotImplementedException();
    }

    @Override
    public void makeTransient() {
        throw new NotImplementedException();
    }

    @Override
    public void makeBridge() {
        throw new NotImplementedException();
    }

    @Override
    public void addAttribute(String named, String text) {
        throw new NotImplementedException();
    }

    @Override
    public void addAttribute(String named, byte[] arr) {
        throw new NotImplementedException();
    }

    @Override
    public void stackMapTable(byte[] bs) {
        throw new NotImplementedException();
    }

    @Override
    public Annotation addRTVAnnotation(String annClass) {
        throw new NotImplementedException();
    }

    @Override
    public Annotation addRTVPAnnotation(String attrClass, int param) {
        throw new NotImplementedException();
    }

    @Override
    public Expr arraylen(Expr var) {
        throw new NotImplementedException();
    }

    @Override
    public Marker marker() {
        throw new NotImplementedException();
    }

    @Override
    public Expr markHere(Remarker m1) {
        throw new NotImplementedException();
    }

    @Override
    public void addStackMapFrame(StackMapFrame type, Marker s, String ... vtypes) {
        throw new NotImplementedException();
    }

    @Override
    public void complete() throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void aaload() {
        throw new NotImplementedException();
    }

    @Override
    public void aastore() {
        throw new NotImplementedException();
    }

    @Override
    public void aconst_null() {
        throw new NotImplementedException();
    }

    @Override
    public void aload(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void anewarray(String clz) {
        throw new NotImplementedException();
    }

    @Override
    public void areturn() {
        throw new NotImplementedException();
    }

    @Override
    public void astore(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void athrow() {
        throw new NotImplementedException();
    }

    @Override
    public void checkCast(String clz) {
        throw new NotImplementedException();
    }

    @Override
    public void dload(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void dreturn() {
        throw new NotImplementedException();
    }

    @Override
    public void dstore(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void dup() {
        throw new NotImplementedException();
    }

    @Override
    public void getField(String clz, String type, String var) {
        throw new NotImplementedException();
    }

    @Override
    public void getStatic(String clz, String type, String var) {
        throw new NotImplementedException();
    }

    @Override
    public void dconst(double d) {
        throw new NotImplementedException();
    }

    @Override
    public void iconst(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void lconst(long l) {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifeq() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifne() {
        throw new NotImplementedException();
    }

    @Override
    public Marker iflt() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifge() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifgt() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifle() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifnull() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifnonnull() {
        throw new NotImplementedException();
    }

    @Override
    public void iload(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void istore(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeOtherConstructor(String clz, String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeParentConstructor(String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeParentMethod(String typeReturn, String method, String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeStatic(String clz, String typeReturn, String method, String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeVirtualMethod(String clz, String ret, String method, String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void invokeInterface(String clz, String ret, String method, String ... args) {
        throw new NotImplementedException();
    }

    @Override
    public void ireturn() {
        throw new NotImplementedException();
    }

    @Override
    public void isInstanceOf(String ofClz) {
        throw new NotImplementedException();
    }

    @Override
    public Marker jump() {
        throw new NotImplementedException();
    }

    @Override
    public void ldcClass(String clz) {
        throw new NotImplementedException();
    }

    @Override
    public void ldcString(String string) {
        throw new NotImplementedException();
    }

    @Override
    public void lload(int i) {
        throw new NotImplementedException();
    }

    @Override
    public void lreturn() {
        throw new NotImplementedException();
    }

    @Override
    public void lstore(int id) {
        throw new NotImplementedException();
    }

    @Override
    public void newObject(String clz) {
        throw new NotImplementedException();
    }

    @Override
    public void pop(String type) {
        throw new NotImplementedException();
    }

    @Override
    public void putField(String clz, String type, String var) {
        throw new NotImplementedException();
    }

    @Override
    public void putStatic(String clz, String type, String var) {
        throw new NotImplementedException();
    }

    @Override
    public void vreturn() {
        throw new NotImplementedException();
    }

    @Override
    public String getClassName() {
        throw new NotImplementedException();
    }

    @Override
    public int stackDepth() {
        throw new NotImplementedException();
    }

    @Override
    public void resetStack(int to) {
        throw new NotImplementedException();
    }

    @Override
    public void addExpression(PCExpr expr) {
        throw new NotImplementedException();
    }

    @Override
    public int currentPC() {
        throw new NotImplementedException();
    }

    @Override
    public Marker ifopcode(int opcode) {
        throw new NotImplementedException();
    }

    private String iname() {
        return new String(new char[]{(char)(65 + this.iv++)});
    }

    public void dump(IndentWriter pw) {
        pw.println((this.isStatic ? "static " : "") + this.name + "() -> " + this.returnType);
        pw.indent().list(this.contents);
    }

    public StreamIExpr makeIExpr() {
        return new StreamIExpr(this.contents, this.iname());
    }
}

